/*
 * Copyright (C) 2022 Apple Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

#pragma once

namespace WGSL {

struct SourcePosition {
    unsigned line;
    unsigned lineOffset;
    unsigned offset;
};

struct SourceSpan {
    // FIXME: we could possibly skip lineOffset and recompute it only when trying to show an error
    // This would shrink the AST size by 32 bits per AST node, at the cost of a bit of code complexity in the error toString function.
    unsigned line;
    unsigned lineOffset;
    unsigned offset;
    unsigned length;

    static constexpr SourceSpan empty() { return { 0, 0, 0, 0 }; }

    constexpr SourceSpan(unsigned line, unsigned lineOffset, unsigned offset, unsigned length)
        : line(line)
        , lineOffset(lineOffset)
        , offset(offset)
        , length(length)
    { }

    constexpr SourceSpan(SourcePosition start, SourcePosition end)
        : SourceSpan(start.line, start.lineOffset, start.offset, end.offset - start.offset)
    { }

    friend constexpr bool operator==(const SourceSpan&, const SourceSpan&) = default;
};

}
