/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2025 Univ. Grenoble Alpes, CNRS, Grenoble INP - UGA, TIMC, 38000 Grenoble, France
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/

#include "console_bindings.h"

#include <iostream>

namespace camitk {

// --------------- PythonConsoleRedirect ---------------
// Redirect Python interpreter stdout/stderr to the C++ standard stream
// (which might be redirected to the camitk console)
// greatly inspired from https://github.com/pybind/pybind11/issues/1622#issuecomment-892387843
// all plumbing is done in the binding below
class PythonConsoleRedirect {
public:
    PythonConsoleRedirect() = default;
    PythonConsoleRedirect(const PythonConsoleRedirect&) = default;
    PythonConsoleRedirect(PythonConsoleRedirect&&) = default;
};

} // namespace camitk

void add_console_bindings(py::module_ &m) {

    py::class_<camitk::PythonConsoleRedirect> pythonConsoleRedirect(m, "pythonConsoleRedirect");

    pythonConsoleRedirect.def_static("write",
    [](py::object buffer) {
        std::cout << buffer.cast<std::string>();
    });

    pythonConsoleRedirect.def_static("flush",
    []() {
        std::cout << std::flush;
    });

    m.def("redirectStandardStreams",
    []() {
        py::module_ py_sys = py::module::import("sys");
        py::module_ camitkPythonModule = py::module::import("camitk");
        py_sys.attr("stdout") = camitkPythonModule.attr("pythonConsoleRedirect");
        py_sys.attr("stderr") = camitkPythonModule.attr("pythonConsoleRedirect");
    });
}