// Code generated by "libovsdb.modelgen"
// DO NOT EDIT.

package ovsmodel

const ACLTable = "ACL"

type (
	ACLAction    = string
	ACLDirection = string
	ACLSeverity  = string
)

var (
	ACLActionAllow          ACLAction    = "allow"
	ACLActionAllowRelated   ACLAction    = "allow-related"
	ACLActionAllowStateless ACLAction    = "allow-stateless"
	ACLActionDrop           ACLAction    = "drop"
	ACLActionReject         ACLAction    = "reject"
	ACLDirectionFromLport   ACLDirection = "from-lport"
	ACLDirectionToLport     ACLDirection = "to-lport"
	ACLSeverityAlert        ACLSeverity  = "alert"
	ACLSeverityWarning      ACLSeverity  = "warning"
	ACLSeverityNotice       ACLSeverity  = "notice"
	ACLSeverityInfo         ACLSeverity  = "info"
	ACLSeverityDebug        ACLSeverity  = "debug"
)

// ACL defines an object in ACL table
type ACL struct {
	UUID        string            `ovsdb:"_uuid"`
	Action      ACLAction         `ovsdb:"action" validate:"oneof='allow' 'allow-related' 'allow-stateless' 'drop' 'reject'"`
	Direction   ACLDirection      `ovsdb:"direction" validate:"oneof='from-lport' 'to-lport'"`
	ExternalIDs map[string]string `ovsdb:"external_ids"`
	Label       int               `ovsdb:"label" validate:"min=0,max=4294967295"`
	Log         bool              `ovsdb:"log"`
	Match       string            `ovsdb:"match"`
	Meter       *string           `ovsdb:"meter"`
	Name        *string           `ovsdb:"name" validate:"omitempty,max=63"`
	Options     map[string]string `ovsdb:"options"`
	Priority    int               `ovsdb:"priority" validate:"min=0,max=32767"`
	Severity    *ACLSeverity      `ovsdb:"severity" validate:"omitempty,oneof='alert' 'warning' 'notice' 'info' 'debug'"`
}
