/* BEGIN software license
 *
 * MsXpertSuite - mass spectrometry software suite
 * -----------------------------------------------
 * Copyright(C) 2009,...,2026 Filippo Rusconi
 *
 * http://www.msxpertsuite.org
 *
 * This file is part of the MsXpertSuite project.
 *
 * The MsXpertSuite project is the successor of the massXpert project. This
 * project now includes various independent modules:
 *
 * - MassXpert, model polymer chemistries and simulate mass spectrometric data;
 * - MineXpert, a powerful TIC chromatogram/mass spectrum viewer/miner;
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * END software license
 */

#pragma once

/////////////////////// stdlib includes


/////////////////////// Qt includes


/////////////////////// pappsomspp includes


/////////////////////// libXpertMass includes
#include <MsXpS/libXpertMassCore/PolChemDef.hpp>


/////////////////////// libXpertMassGui includes


/////////////////////// Local includes
#include "AbstractPolChemDefDependentDlg.hpp"
#include "ui_ModifDefDlg.h"


namespace MsXpS
{
namespace MassXpert
{


class PolChemDef;
class PolChemDefWnd;
class Modif;


class ModifDefDlg : public AbstractPolChemDefDependentDlg
{
  Q_OBJECT

  public:
  ModifDefDlg(libXpertMassCore::PolChemDefSPtr pol_chem_def_sp,
              PolChemDefWnd *pol_chem_def_wnd_p,
              const QString &settings_file_path,
              const QString &application_name,
              const QString &description);

  ~ModifDefDlg();

  bool initialize();

  void updateModifDetails(libXpertMassCore::ModifSPtr modif_sp);

  void clearAllDetails();

  public slots:

  // ACTIONS
  void addModifPushButtonClicked();
  void removeModifPushButtonClicked();
  void moveUpModifPushButtonClicked();
  void moveDownModifPushButtonClicked();

  void applyModifPushButtonClicked();

  bool validatePushButtonClicked();

  // VALIDATION
  bool validate();

  // WIDGETRY
  void modifListWidgetItemSelectionChanged();

  private:
  Ui::ModifDefDlg m_ui;

  std::vector<libXpertMassCore::ModifSPtr> &mref_modifs;

  void closeEvent(QCloseEvent *event);

  void writeSettings();
  void readSettings();
};


} // namespace MassXpert
} // namespace MsXpS
