/*
 * Decompiled with CFR 0.152.
 */
package org.chefproject.service.component;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.ServletConfig;
import org.apache.jetspeed.services.statemanager.SessionStateBindingListener;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.util.Log;
import org.apache.turbine.util.RunData;
import org.chefproject.core.Assignment;
import org.chefproject.core.AssignmentContent;
import org.chefproject.core.AssignmentContentEdit;
import org.chefproject.core.AssignmentEdit;
import org.chefproject.core.AssignmentSubmission;
import org.chefproject.core.AssignmentSubmissionEdit;
import org.chefproject.core.AttachmentContainer;
import org.chefproject.core.ContentResource;
import org.chefproject.core.Edit;
import org.chefproject.core.Event;
import org.chefproject.core.Resource;
import org.chefproject.core.ResourceProperties;
import org.chefproject.core.ResourcePropertiesEdit;
import org.chefproject.core.StorageUser;
import org.chefproject.core.User;
import org.chefproject.core.component.BaseResourcePropertiesEdit;
import org.chefproject.exception.AssignmentContentNotEmptyException;
import org.chefproject.exception.AssignmentNotEmptyException;
import org.chefproject.exception.IdInvalidException;
import org.chefproject.exception.IdUnusedException;
import org.chefproject.exception.IdUsedException;
import org.chefproject.exception.InUseException;
import org.chefproject.exception.PermissionException;
import org.chefproject.exception.TypeException;
import org.chefproject.service.ContentHostingService;
import org.chefproject.service.EventTrackingService;
import org.chefproject.service.IdService;
import org.chefproject.service.SecurityService;
import org.chefproject.service.ServerConfigurationService;
import org.chefproject.service.UsageSessionService;
import org.chefproject.service.UserDirectoryService;
import org.chefproject.service.generic.GenericAssignmentService;
import org.chefproject.util.Blob;
import org.chefproject.util.Cache;
import org.chefproject.util.CacheRefresher;
import org.chefproject.util.EmptyIterator;
import org.chefproject.util.FlexStringArray;
import org.chefproject.util.Reference;
import org.chefproject.util.ReferenceVector;
import org.chefproject.util.StringUtil;
import org.chefproject.util.Time;
import org.chefproject.util.Validator;
import org.chefproject.util.Xml;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class BaseAssignmentService
extends TurbineBaseService
implements GenericAssignmentService {
    protected AssignmentStorage m_assignmentStorage = null;
    protected AssignmentContentStorage m_contentStorage = null;
    protected AssignmentSubmissionStorage m_submissionStorage = null;
    protected Cache m_assignmentCache = null;
    protected Cache m_contentCache = null;
    protected Cache m_submissionCache = null;
    protected String m_accessPoint = null;
    protected String m_relativeAccessPoint = null;

    protected abstract AssignmentStorage newAssignmentStorage();

    protected abstract AssignmentContentStorage newContentStorage();

    protected abstract AssignmentSubmissionStorage newSubmissionStorage();

    protected String getAccessPoint(boolean relative) {
        return relative ? this.getReferenceRoot() : this.m_accessPoint;
    }

    public String assignmentReference(String context, String id) {
        String retVal = null;
        retVal = context == null ? this.getAccessPoint(true) + "/" + "a" + "/" + id : this.getAccessPoint(true) + "/" + "a" + "/" + context + "/" + id;
        return retVal;
    }

    public String contentReference(String context, String id) {
        String retVal = null;
        retVal = context == null ? this.getAccessPoint(true) + "/" + "c" + "/" + id : this.getAccessPoint(true) + "/" + "c" + "/" + context + "/" + id;
        return retVal;
    }

    public String submissionReference(String context, String id, String assignmentId) {
        String retVal = null;
        retVal = context == null ? this.getAccessPoint(true) + "/" + "s" + "/" + id : this.getAccessPoint(true) + "/" + "s" + "/" + context + "/" + assignmentId + "/" + id;
        return retVal;
    }

    protected String assignmentId(String ref) {
        int i = ref.lastIndexOf("/");
        if (i == -1) {
            return ref;
        }
        String id = ref.substring(i + 1);
        return id;
    }

    protected String contentId(String ref) {
        int i = ref.lastIndexOf("/");
        if (i == -1) {
            return ref;
        }
        String id = ref.substring(i + 1);
        return id;
    }

    protected String submissionId(String ref) {
        int i = ref.lastIndexOf("/");
        if (i == -1) {
            return ref;
        }
        String id = ref.substring(i + 1);
        return id;
    }

    protected boolean unlockCheck(String lock, String resource) {
        return SecurityService.unlock(lock, resource);
    }

    protected boolean unlockCheck2(String lock1, String lock2, String resource) {
        return SecurityService.unlock(lock1, resource) || SecurityService.unlock(lock2, resource);
    }

    protected void unlock(String lock, String resource) throws PermissionException {
        if (!this.unlockCheck(lock, resource)) {
            throw new PermissionException(UsageSessionService.getSessionUser().getId(), lock, resource);
        }
    }

    protected void unlock2(String lock1, String lock2, String resource) throws PermissionException {
        if (!this.unlockCheck2(lock1, lock2, resource)) {
            throw new PermissionException(UsageSessionService.getSessionUser().getId(), lock1 + "/" + lock2, resource);
        }
    }

    public void init(ServletConfig config) throws InitializationException {
        super.init(config);
        Log.info("chef", this + ".init(ServletConfig)");
    }

    public void init(RunData data) throws InitializationException {
        this.m_relativeAccessPoint = "/assignment";
        this.m_accessPoint = ServerConfigurationService.getAccessUrl() + this.m_relativeAccessPoint;
        super.init(data);
        Log.info("chef", this + ".init(RunData): access point: " + this.m_accessPoint);
    }

    public void init() throws InitializationException {
        super.init();
        Log.info("chef", this + ".init()");
        this.m_assignmentStorage = this.newAssignmentStorage();
        this.m_assignmentStorage.open();
        this.m_contentStorage = this.newContentStorage();
        this.m_contentStorage.open();
        this.m_submissionStorage = this.newSubmissionStorage();
        this.m_submissionStorage.open();
        this.m_assignmentCache = new Cache((CacheRefresher)new AssignmentCacheRefresher(), this.assignmentReference(null, ""));
        this.m_contentCache = new Cache((CacheRefresher)new AssignmentContentCacheRefresher(), this.contentReference(null, ""));
        this.m_submissionCache = new Cache((CacheRefresher)new AssignmentSubmissionCacheRefresher(), this.submissionReference(null, "", ""));
    }

    public void shutdown() {
        this.m_assignmentCache.clear();
        this.m_assignmentCache = null;
        this.m_contentCache.clear();
        this.m_contentCache = null;
        this.m_submissionCache.clear();
        this.m_submissionCache = null;
        this.m_assignmentStorage.close();
        this.m_assignmentStorage = null;
        this.m_contentStorage.close();
        this.m_contentStorage = null;
        this.m_submissionStorage.close();
        this.m_submissionStorage = null;
        Log.info("chef", this + ".shutdown()");
        super.shutdown();
    }

    public AssignmentEdit addAssignment(String context) throws PermissionException {
        if (Log.getLogger("chef").isDebugEnabled()) {
            Log.debug("chef", "ASSIGNMENT : BASE SERVICE : ENTERING ADD ASSIGNMENT : CONTEXT : " + context);
        }
        String assignmentId = null;
        boolean badId = false;
        do {
            badId = false;
            assignmentId = IdService.getUniqueId();
            try {
                Validator.checkResourceId(assignmentId);
            }
            catch (IdInvalidException iie) {
                badId = true;
            }
            if (!this.m_assignmentStorage.check(assignmentId)) continue;
            badId = true;
        } while (badId);
        String key = this.assignmentReference(context, assignmentId);
        this.unlock("asn.new", key);
        AssignmentEdit assignment = this.m_assignmentStorage.put(assignmentId, context);
        EventTrackingService.post(EventTrackingService.newEvent("asn.new", key, true));
        if (Log.getLogger("chef").isDebugEnabled()) {
            Log.debug("chef", "ASSIGNMENT : BASE SERVICE : LEAVING ADD ASSIGNMENT WITH : ID : " + assignment.getId());
        }
        return assignment;
    }

    public AssignmentEdit mergeAssignment(Element el) throws IdInvalidException, IdUsedException, PermissionException {
        BaseAssignment assignmentFromXml = new BaseAssignment(el);
        Validator.checkResourceId(assignmentFromXml.getId());
        this.unlock("asn.new", assignmentFromXml.getReference());
        AssignmentEdit assignment = this.m_assignmentStorage.put(assignmentFromXml.getId(), assignmentFromXml.getContext());
        if (assignment == null) {
            throw new IdUsedException(assignmentFromXml.getId());
        }
        ((BaseAssignmentEdit)assignment).set(assignmentFromXml);
        ((BaseAssignmentEdit)assignment).setEvent("asn.new");
        return assignment;
    }

    public AssignmentEdit addDuplicateAssignment(String context, String assignmentReference) throws PermissionException, IdInvalidException, IdUsedException, IdUnusedException {
        if (Log.getLogger("chef").isDebugEnabled()) {
            Log.debug("chef", "ASSIGNMENT : BASE SERVICE : ENTERING ADD DUPLICATE ASSIGNMENT WITH ID : " + assignmentReference);
        }
        Vector tempVector = new Vector();
        Object tempString = null;
        Object tempRef = null;
        Object newRef = null;
        Resource retVal = null;
        Object existingProps = null;
        if (assignmentReference != null) {
            String assignmentId = this.assignmentId(assignmentReference);
            if (!this.m_assignmentStorage.check(assignmentId)) {
                throw new IdUnusedException(assignmentId);
            }
            if (Log.getLogger("chef").isDebugEnabled()) {
                Log.debug("chef", "ASSIGNMENT : BASE SERVICE : addDuplicateAssignment : assignment exists - will copy");
            }
            Assignment existingAssignment = this.getAssignment(assignmentReference);
            retVal = this.addAssignment(context);
            retVal.setContentReference(existingAssignment.getContentReference());
            retVal.setTitle(existingAssignment.getTitle() + " - Copy");
            retVal.setSection(existingAssignment.getSection());
            retVal.setOpenTime(existingAssignment.getOpenTime());
            retVal.setDueTime(existingAssignment.getDueTime());
            retVal.setDropDeadTime(existingAssignment.getDropDeadTime());
            retVal.setCloseTime(existingAssignment.getCloseTime());
            retVal.setDraft(existingAssignment.getDraft());
            ((BaseResourcePropertiesEdit)retVal.getProperties()).addAll(existingAssignment.getProperties());
        }
        if (Log.getLogger("chef").isDebugEnabled()) {
            Log.debug("chef", "ASSIGNMENT : BASE SERVICE : ADD DUPLICATE ASSIGNMENT : LEAVING ADD DUPLICATE ASSIGNMENT WITH ID : " + retVal.getId());
        }
        return retVal;
    }

    public Assignment getAssignment(String assignmentReference) throws IdUnusedException, PermissionException {
        if (Log.getLogger("chef").isDebugEnabled()) {
            Log.debug("chef", "ASSIGNMENT : BASE SERVICE : GET ASSIGNMENT : REF : " + assignmentReference);
        }
        Assignment assignment = null;
        String assignmentId = this.assignmentId(assignmentReference);
        if (this.m_assignmentCache.containsKey(assignmentReference)) {
            assignment = (Assignment)this.m_assignmentCache.get(assignmentReference);
        } else {
            assignment = this.m_assignmentStorage.get(assignmentId);
            this.m_assignmentCache.put(assignmentReference, assignment);
        }
        if (assignment == null) {
            throw new IdUnusedException(assignmentId);
        }
        this.unlock("asn.read", assignmentReference);
        if (Log.getLogger("chef").isDebugEnabled()) {
            Log.debug("chef", "ASSIGNMENT : BASE SERVICE : GOT ASSIGNMENT : ID : " + assignment.getId());
        }
        EventTrackingService.post(EventTrackingService.newEvent("asn.read", assignment.getReference(), false));
        return assignment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List getAssignments() {
        List assignments = new Vector();
        if (this.m_assignmentCache.disabled()) {
            assignments = this.m_assignmentStorage.getAll();
        } else if (this.m_assignmentCache.isComplete()) {
            assignments = this.m_assignmentCache.getAll();
        } else {
            Cache cache = this.m_assignmentCache;
            synchronized (cache) {
                block9: {
                    if (!this.m_assignmentCache.isComplete()) break block9;
                    assignments = this.m_assignmentCache.getAll();
                    List list = assignments;
                    return list;
                }
                this.m_assignmentCache.holdEvents();
                assignments = this.m_assignmentStorage.getAll();
                int i = 0;
                while (i < assignments.size()) {
                    Assignment assignment = (Assignment)assignments.get(i);
                    this.m_assignmentCache.put(assignment.getReference(), assignment);
                    ++i;
                }
                this.m_assignmentCache.setComplete();
                this.m_assignmentCache.processEvents();
            }
        }
        return assignments;
    }

    public AssignmentEdit editAssignment(String assignmentReference) throws IdUnusedException, PermissionException, InUseException {
        String assignmentId = this.assignmentId(assignmentReference);
        Assignment assignment = this.getAssignment(assignmentReference);
        if (assignment == null) {
            throw new IdUnusedException(assignmentId);
        }
        this.unlock("asn.revise", assignment.getReference());
        AssignmentEdit assignmentEdit = this.m_assignmentStorage.edit(assignmentId);
        if (assignmentEdit == null) {
            throw new InUseException(assignmentId);
        }
        ((BaseAssignmentEdit)assignmentEdit).setEvent("asn.revise");
        return assignmentEdit;
    }

    public void commitEdit(AssignmentEdit assignment) {
        if (!assignment.isActiveEdit()) {
            try {
                throw new Exception();
            }
            catch (Exception e) {
                Log.warn("chef", this + ".commitEdit(): closed AssignmentEdit", (Throwable)e);
                return;
            }
        }
        this.addLiveUpdateProperties(assignment.getPropertiesEdit());
        assignment.setTimeLastModified(new Time());
        this.m_assignmentStorage.commit(assignment);
        EventTrackingService.post(EventTrackingService.newEvent(((BaseAssignmentEdit)assignment).getEvent(), assignment.getReference(), true));
        ((BaseAssignmentEdit)assignment).closeEdit();
    }

    public void cancelEdit(AssignmentEdit assignment) {
        if (!assignment.isActiveEdit()) {
            try {
                throw new Exception();
            }
            catch (Exception e) {
                Log.warn("chef", this + ".cancelEdit(): closed AssignmentEdit", (Throwable)e);
                return;
            }
        }
        this.m_assignmentStorage.cancel(assignment);
        ((BaseAssignmentEdit)assignment).closeEdit();
    }

    public void removeAssignment(AssignmentEdit assignment) throws AssignmentNotEmptyException, PermissionException {
        if (assignment != null) {
            if (Log.getLogger("chef").isDebugEnabled()) {
                Log.debug("chef", "BaseAssignmentService :  removeAssignment with id : " + assignment.getId());
            }
            if (!assignment.isActiveEdit()) {
                try {
                    throw new Exception();
                }
                catch (Exception e) {
                    Log.warn("chef", this + ".removeAssignment(): closed AssignmentEdit", (Throwable)e);
                    return;
                }
            }
            this.unlock("asn.delete", assignment.getReference());
            this.m_assignmentStorage.remove(assignment);
            EventTrackingService.post(EventTrackingService.newEvent("asn.delete", assignment.getReference(), true));
            ((BaseAssignmentEdit)assignment).closeEdit();
        }
    }

    public AssignmentContentEdit addAssignmentContent(String context) throws PermissionException {
        if (Log.getLogger("chef").isDebugEnabled()) {
            Log.debug("chef", "ASSIGNMENT : BASE SERVICE : ENTERING ADD ASSIGNMENT CONTENT");
        }
        String contentId = null;
        boolean badId = false;
        do {
            badId = false;
            contentId = IdService.getUniqueId();
            try {
                Validator.checkResourceId(contentId);
            }
            catch (IdInvalidException iie) {
                badId = true;
            }
            if (!this.m_contentStorage.check(contentId)) continue;
            badId = true;
        } while (badId);
        this.unlock("asn.new", this.contentReference(context, contentId));
        AssignmentContentEdit content = this.m_contentStorage.put(contentId, context);
        if (Log.getLogger("chef").isDebugEnabled()) {
            Log.debug("chef", "ASSIGNMENT : BASE SERVICE : LEAVING ADD ASSIGNMENT CONTENT : ID : " + content.getId());
        }
        EventTrackingService.post(EventTrackingService.newEvent("asn.new", content.getReference(), true));
        return content;
    }

    public AssignmentContentEdit mergeAssignmentContent(Element el) throws IdInvalidException, IdUsedException, PermissionException {
        BaseAssignmentContent contentFromXml = new BaseAssignmentContent(el);
        Validator.checkResourceId(contentFromXml.getId());
        this.unlock("asn.new", contentFromXml.getReference());
        AssignmentContentEdit content = this.m_contentStorage.put(contentFromXml.getId(), contentFromXml.getContext());
        if (content == null) {
            throw new IdUsedException(contentFromXml.getId());
        }
        ((BaseAssignmentContentEdit)content).set(contentFromXml);
        ((BaseAssignmentContentEdit)content).setEvent("asn.new");
        return content;
    }

    public AssignmentContent addDuplicateAssignmentContent(String context, String contentReference) throws PermissionException, IdInvalidException, IdUnusedException {
        if (Log.getLogger("chef").isDebugEnabled()) {
            Log.debug("chef", "ASSIGNMENT : BASE SERVICE : ENTERING ADD DUPLICATE ASSIGNMENT CONTENT : " + contentReference);
        }
        Resource retVal = null;
        AssignmentContent existingContent = null;
        ReferenceVector tempVector = null;
        Object tempString = null;
        Object newContentId = null;
        Reference tempRef = null;
        Reference newRef = null;
        if (contentReference != null) {
            String contentId = this.contentId(contentReference);
            if (!this.m_contentStorage.check(contentId)) {
                throw new IdUnusedException(contentId);
            }
            if (Log.getLogger("chef").isDebugEnabled()) {
                Log.debug("chef", "ASSIGNMENT : BASE SERVICE : ADD DUPL. CONTENT : found match - will copy");
            }
            existingContent = this.getAssignmentContent(contentReference);
            retVal = this.addAssignmentContent(context);
            ((BaseResourcePropertiesEdit)retVal.getProperties()).addAll(existingContent.getProperties());
            retVal.setTitle(existingContent.getTitle() + " - Copy");
            retVal.setInstructions(existingContent.getInstructions());
            retVal.setHonorPledge(existingContent.getHonorPledge());
            retVal.setTypeOfSubmission(existingContent.getTypeOfSubmission());
            retVal.setTypeOfGrade(existingContent.getTypeOfGrade());
            retVal.setMaxGradePoint(existingContent.getMaxGradePoint());
            retVal.setGroupProject(existingContent.getGroupProject());
            retVal.setIndividuallyGraded(existingContent.individuallyGraded());
            retVal.setReleaseGrades(existingContent.releaseGrades());
            retVal.setAllowAttachments(existingContent.getAllowAttachments());
            tempVector = existingContent.getAttachments();
            if (tempVector != null) {
                int z = 0;
                while (z < tempVector.size()) {
                    tempRef = (Reference)tempVector.get(z);
                    if (tempRef != null) {
                        newRef = new Reference(tempRef);
                        retVal.addAttachment(newRef);
                    }
                    ++z;
                }
            }
        }
        if (Log.getLogger("chef").isDebugEnabled()) {
            Log.debug("chef", "ASSIGNMENT : BASE SERVICE : LEAVING ADD DUPLICATE CONTENT WITH ID : " + retVal.getId());
        }
        return retVal;
    }

    public AssignmentContent getAssignmentContent(String contentReference) throws IdUnusedException, PermissionException {
        if (Log.getLogger("chef").isDebugEnabled()) {
            Log.debug("chef", "ASSIGNMENT : BASE SERVICE : GET CONTENT : ID : " + contentReference);
        }
        AssignmentContent content = null;
        String contentId = this.contentId(contentReference);
        if (this.m_contentCache.containsKey(contentReference)) {
            content = (AssignmentContent)this.m_contentCache.get(contentReference);
        } else {
            content = this.m_contentStorage.get(contentId);
            this.m_contentCache.put(contentReference, content);
        }
        this.unlock("asn.read", contentReference);
        if (content == null) {
            throw new IdUnusedException(contentId);
        }
        if (Log.getLogger("chef").isDebugEnabled()) {
            Log.debug("chef", "ASSIGNMENT : BASE SERVICE : GOT ASSIGNMENT CONTENT : ID : " + content.getId());
        }
        EventTrackingService.post(EventTrackingService.newEvent("asn.read", content.getReference(), false));
        return content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getAssignmentContents() {
        List contents = new Vector();
        if (this.m_contentCache.disabled()) {
            contents = this.m_contentStorage.getAll();
        } else if (this.m_contentCache.isComplete()) {
            contents = this.m_contentCache.getAll();
        } else {
            Cache cache = this.m_contentCache;
            synchronized (cache) {
                block9: {
                    if (!this.m_contentCache.isComplete()) break block9;
                    contents = this.m_contentCache.getAll();
                    List list = contents;
                    return list;
                }
                this.m_contentCache.holdEvents();
                contents = this.m_contentStorage.getAll();
                int i = 0;
                while (i < contents.size()) {
                    AssignmentContent content = (AssignmentContent)contents.get(i);
                    this.m_contentCache.put(content.getReference(), content);
                    ++i;
                }
                this.m_contentCache.setComplete();
                this.m_contentCache.processEvents();
            }
        }
        return contents;
    }

    public AssignmentContentEdit editAssignmentContent(String contentReference) throws IdUnusedException, PermissionException, InUseException {
        this.unlock("asn.revise", contentReference);
        String contentId = this.contentId(contentReference);
        if (this.m_contentCache.get(contentReference) == null && !this.m_contentStorage.check(contentId)) {
            throw new IdUnusedException(contentId);
        }
        AssignmentContentEdit content = this.m_contentStorage.edit(contentId);
        if (content == null) {
            throw new InUseException(contentId);
        }
        ((BaseAssignmentContentEdit)content).setEvent("asn.revise");
        return content;
    }

    public void commitEdit(AssignmentContentEdit content) {
        if (!content.isActiveEdit()) {
            try {
                throw new Exception();
            }
            catch (Exception e) {
                Log.warn("chef", this + ".commitEdit(): closed AssignmentContentEdit", (Throwable)e);
                return;
            }
        }
        this.addLiveUpdateProperties(content.getPropertiesEdit());
        content.setTimeLastModified(new Time());
        this.m_contentStorage.commit(content);
        EventTrackingService.post(EventTrackingService.newEvent(((BaseAssignmentContentEdit)content).getEvent(), content.getReference(), true));
        ((BaseAssignmentContentEdit)content).closeEdit();
    }

    public void cancelEdit(AssignmentContentEdit content) {
        if (!content.isActiveEdit()) {
            try {
                throw new Exception();
            }
            catch (Exception e) {
                Log.warn("chef", this + ".cancelEdit(): closed AssignmentContentEdit", (Throwable)e);
                return;
            }
        }
        this.m_contentStorage.cancel(content);
        ((BaseAssignmentContentEdit)content).closeEdit();
    }

    public void removeAssignmentContent(AssignmentContentEdit content) throws AssignmentContentNotEmptyException, PermissionException {
        if (content != null) {
            if (content.inUse()) {
                throw new AssignmentContentNotEmptyException();
            }
            if (!content.isActiveEdit()) {
                try {
                    throw new Exception();
                }
                catch (Exception e) {
                    Log.warn("chef", this + ".removeAssignmentContent(): closed AssignmentContentEdit", (Throwable)e);
                    return;
                }
            }
            this.unlock("asn.delete", content.getReference());
            this.m_contentStorage.remove(content);
            EventTrackingService.post(EventTrackingService.newEvent("asn.delete", content.getReference(), true));
            ((BaseAssignmentContentEdit)content).closeEdit();
        }
    }

    public AssignmentSubmissionEdit addSubmission(String context, String assignmentId) throws PermissionException {
        if (Log.getLogger("chef").isDebugEnabled()) {
            Log.debug("chef", "ASSIGNMENT : BASE SERVICE : ENTERING ADD SUBMISSION");
        }
        String submissionId = null;
        boolean badId = false;
        do {
            badId = false;
            submissionId = IdService.getUniqueId();
            try {
                Validator.checkResourceId(submissionId);
            }
            catch (IdInvalidException iie) {
                badId = true;
            }
            if (!this.m_submissionStorage.check(submissionId)) continue;
            badId = true;
        } while (badId);
        String key = this.submissionReference(context, submissionId, assignmentId);
        if (Log.getLogger("chef").isDebugEnabled()) {
            Log.debug("chef", "ASSIGNMENT : BASE SERVICE : ADD SUBMISSION : SUB REF : " + key);
        }
        this.unlock("asn.submit", key);
        if (Log.getLogger("chef").isDebugEnabled()) {
            Log.debug("chef", "ASSIGNMENT : BASE SERVICE : ADD SUBMISSION : UNLOCKED");
        }
        AssignmentSubmissionEdit submission = this.m_submissionStorage.put(submissionId, context, assignmentId);
        if (Log.getLogger("chef").isDebugEnabled()) {
            Log.debug("chef", "ASSIGNMENT : BASE SERVICE : LEAVING ADD SUBMISSION : REF : " + submission.getReference());
        }
        EventTrackingService.post(EventTrackingService.newEvent("asn.submit", key, true));
        return submission;
    }

    public AssignmentSubmissionEdit mergeSubmission(Element el) throws IdInvalidException, IdUsedException, PermissionException {
        BaseAssignmentSubmission submissionFromXml = new BaseAssignmentSubmission(el);
        Validator.checkResourceId(submissionFromXml.getId());
        this.unlock("asn.submit", submissionFromXml.getReference());
        AssignmentSubmissionEdit submission = this.m_submissionStorage.put(submissionFromXml.getId(), submissionFromXml.getContext(), submissionFromXml.getAssignmentId());
        if (submission == null) {
            throw new IdUsedException(submissionFromXml.getId());
        }
        ((BaseAssignmentSubmissionEdit)submission).set(submissionFromXml);
        ((BaseAssignmentSubmissionEdit)submission).setEvent("asn.submit");
        return submission;
    }

    public AssignmentSubmissionEdit editSubmission(String submissionReference) throws IdUnusedException, PermissionException, InUseException {
        this.unlock2("asn.submit", "asn.revise", submissionReference);
        String submissionId = this.submissionId(submissionReference);
        if (this.m_submissionCache.get(submissionReference) == null && !this.m_submissionStorage.check(submissionId)) {
            throw new IdUnusedException(submissionId);
        }
        AssignmentSubmissionEdit submission = this.m_submissionStorage.edit(submissionId);
        if (submission == null) {
            throw new InUseException(submissionId);
        }
        ((BaseAssignmentSubmissionEdit)submission).setEvent("asn.submit");
        return submission;
    }

    public void commitEdit(AssignmentSubmissionEdit submission) {
        if (!submission.isActiveEdit()) {
            try {
                throw new Exception();
            }
            catch (Exception e) {
                Log.warn("chef", this + ".commitEdit(): closed AssignmentSubmissionEdit", (Throwable)e);
                return;
            }
        }
        this.addLiveUpdateProperties(submission.getPropertiesEdit());
        submission.setTimeLastModified(new Time());
        this.m_submissionStorage.commit(submission);
        EventTrackingService.post(EventTrackingService.newEvent(((BaseAssignmentSubmissionEdit)submission).getEvent(), submission.getReference(), true));
        ((BaseAssignmentSubmissionEdit)submission).closeEdit();
    }

    public void cancelEdit(AssignmentSubmissionEdit submission) {
        if (!submission.isActiveEdit()) {
            try {
                throw new Exception();
            }
            catch (Exception e) {
                Log.warn("chef", this + ".cancelEdit(): closed AssignmentSubmissionEdit", (Throwable)e);
                return;
            }
        }
        this.m_submissionStorage.cancel(submission);
        ((BaseAssignmentSubmissionEdit)submission).closeEdit();
    }

    public void removeSubmission(AssignmentSubmissionEdit submission) throws PermissionException {
        if (submission != null) {
            if (!submission.isActiveEdit()) {
                try {
                    throw new Exception();
                }
                catch (Exception e) {
                    Log.warn("chef", this + ".removeSubmission(): closed AssignmentSubmissionEdit", (Throwable)e);
                    return;
                }
            }
            this.unlock("asn.delete", submission.getReference());
            this.m_submissionStorage.remove(submission);
            EventTrackingService.post(EventTrackingService.newEvent("asn.delete", submission.getReference(), true));
            ((BaseAssignmentSubmissionEdit)submission).closeEdit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getSubmissions() {
        List submissions = new Vector();
        if (this.m_submissionCache.disabled()) {
            submissions = this.m_submissionStorage.getAll();
        } else if (this.m_submissionCache.isComplete()) {
            submissions = this.m_submissionCache.getAll();
        } else {
            Cache cache = this.m_submissionCache;
            synchronized (cache) {
                block9: {
                    if (!this.m_submissionCache.isComplete()) break block9;
                    submissions = this.m_submissionCache.getAll();
                    List list = submissions;
                    return list;
                }
                this.m_submissionCache.holdEvents();
                submissions = this.m_submissionStorage.getAll();
                int i = 0;
                while (i < submissions.size()) {
                    AssignmentSubmission submission = (AssignmentSubmission)submissions.get(i);
                    this.m_submissionCache.put(submission.getReference(), submission);
                    ++i;
                }
                this.m_submissionCache.setComplete();
                this.m_submissionCache.processEvents();
            }
        }
        return submissions;
    }

    public Iterator getAssignmentContents(User owner) {
        Vector<AssignmentContent> retVal = new Vector<AssignmentContent>();
        AssignmentContent aContent = null;
        List allContents = this.getAssignmentContents();
        int x = 0;
        while (x < allContents.size()) {
            try {
                aContent = (AssignmentContent)allContents.get(x);
                if (aContent.getCreator().equals(owner.getId())) {
                    // empty if block
                }
                retVal.add(aContent);
            }
            catch (Exception e) {
                // empty catch block
            }
            ++x;
        }
        if (retVal.isEmpty()) {
            return new EmptyIterator();
        }
        return retVal.iterator();
    }

    public Iterator getAssignments(AssignmentContent content) {
        Vector<Assignment> retVal = new Vector<Assignment>();
        String contentReference = null;
        String tempContentReference = null;
        if (content != null) {
            contentReference = content.getReference();
            List allAssignments = this.getAssignments();
            Assignment tempAssignment = null;
            int y = 0;
            while (y < allAssignments.size()) {
                tempAssignment = (Assignment)allAssignments.get(y);
                tempContentReference = tempAssignment.getContentReference();
                if (tempContentReference != null && tempContentReference.equals(contentReference)) {
                    retVal.add(tempAssignment);
                }
                ++y;
            }
        }
        if (retVal.isEmpty()) {
            return new EmptyIterator();
        }
        return retVal.iterator();
    }

    public Iterator getAssignmentsForContext(String context) {
        if (Log.getLogger("chef").isDebugEnabled()) {
            Log.debug("chef", "ASSIGNMENT : BASE SERVICE : GET ASSIGNMENTS FOR CONTEXT : CONTEXT : " + context);
        }
        Assignment tempAssignment = null;
        Vector<Assignment> retVal = new Vector<Assignment>();
        List allAssignments = null;
        Object aGroup = null;
        if (context != null) {
            allAssignments = this.getAssignments();
            int x = 0;
            while (x < allAssignments.size()) {
                tempAssignment = (Assignment)allAssignments.get(x);
                if (context.equals(tempAssignment.getContext()) || context.equals(this.getGroupNameFromContext(tempAssignment.getContext()))) {
                    retVal.add(tempAssignment);
                }
                ++x;
            }
        }
        if (retVal.isEmpty()) {
            return new EmptyIterator();
        }
        return retVal.iterator();
    }

    public AssignmentSubmission getSubmission(String assignmentReference, User person) throws IdUnusedException, PermissionException {
        Assignment assign;
        Resource retVal = null;
        AssignmentSubmission sub = null;
        Object subString = null;
        FlexStringArray submitters = null;
        String aUserId = null;
        String assignmentId = this.assignmentId(assignmentReference);
        if (!this.m_assignmentStorage.check(assignmentId)) {
            throw new IdUnusedException(assignmentId);
        }
        if (assignmentReference != null && person != null && (assign = this.m_assignmentStorage.get(assignmentId)) != null) {
            if (Log.getLogger("chef").isDebugEnabled()) {
                Log.debug("chef", "getSubmission : Got assignment with id : " + assign.getId());
            }
            try {
                List submissions = this.getSubmissions();
                int z = 0;
                while (z < submissions.size()) {
                    sub = (AssignmentSubmission)submissions.get(z);
                    if (Log.getLogger("chef").isDebugEnabled()) {
                        Log.debug("chef", "getSubmission : submission id found : " + sub.getId());
                    }
                    if (sub != null && sub.getAssignmentId().equals(assignmentId)) {
                        submitters = sub.getSubmitterIds();
                        int a = 0;
                        while (a < submitters.size()) {
                            aUserId = submitters.get(a);
                            if (Log.getLogger("chef").isDebugEnabled()) {
                                Log.debug("chef", "getSubmission : comparing aUser id : " + aUserId + " and chosen user id : " + person.getId());
                            }
                            if (aUserId.equals(person.getId())) {
                                if (Log.getLogger("chef").isDebugEnabled()) {
                                    Log.debug("chef", "getSubmission : found a match : return value is " + sub.getId());
                                }
                                retVal = sub;
                            }
                            ++a;
                        }
                    }
                    ++z;
                }
            }
            catch (Exception e) {
                Log.warn("chef", "getSubmission : EXCEPTION : " + e);
            }
        }
        if (retVal != null) {
            this.unlock2("asn.submit", "asn.read", retVal.getReference());
            EventTrackingService.post(EventTrackingService.newEvent("asn.submit", retVal.getReference(), false));
        }
        return retVal;
    }

    public Iterator getSubmissions(Assignment assignment) {
        AssignmentSubmission submission = null;
        Vector<AssignmentSubmission> retVal = new Vector<AssignmentSubmission>();
        if (assignment != null) {
            List allSubmissions = this.getSubmissions();
            int x = 0;
            while (x < allSubmissions.size()) {
                submission = (AssignmentSubmission)allSubmissions.get(x);
                if (assignment.getId().equals(submission.getAssignmentId())) {
                    retVal.add(submission);
                }
                ++x;
            }
        }
        if (retVal.isEmpty()) {
            return new EmptyIterator();
        }
        return retVal.iterator();
    }

    public AssignmentSubmission getSubmission(String submissionReference) throws IdUnusedException, PermissionException {
        if (Log.getLogger("chef").isDebugEnabled()) {
            Log.debug("chef", "ASSIGNMENT : BASE SERVICE : GET SUBMISSION : REF : " + submissionReference);
        }
        AssignmentSubmission submission = null;
        String submissionId = this.submissionId(submissionReference);
        if (this.m_submissionCache.containsKey(submissionReference)) {
            submission = (AssignmentSubmission)this.m_submissionCache.get(submissionReference);
        } else {
            submission = this.m_submissionStorage.get(submissionId);
            this.m_submissionCache.put(submissionReference, submission);
        }
        if (submission == null) {
            throw new IdUnusedException(submissionId);
        }
        this.unlock2("asn.submit", "asn.read", submissionReference);
        if (Log.getLogger("chef").isDebugEnabled()) {
            Log.debug("chef", "ASSIGNMENT : BASE SERVICE : GOT SUBMISSION : ID : " + submission.getId());
        }
        EventTrackingService.post(EventTrackingService.newEvent("asn.submit", submission.getReference(), false));
        return submission;
    }

    protected String getReferenceRoot() {
        return "/assignment";
    }

    protected void addLiveUpdateProperties(ResourcePropertiesEdit props) {
        props.addProperty("CHEF:modifiedby", UsageSessionService.getSessionUser().getId());
        props.addProperty("DAV:getlastmodified", new Time().toString());
    }

    protected void addLiveProperties(ResourcePropertiesEdit props) {
        String current = UsageSessionService.getSessionUser().getId();
        props.addProperty("CHEF:creator", current);
        props.addProperty("CHEF:modifiedby", current);
        String now = new Time().toString();
        props.addProperty("DAV:creationdate", now);
        props.addProperty("DAV:getlastmodified", now);
    }

    public boolean allowAddAssignment(String context) {
        String resourceString = this.getAccessPoint(true) + "/" + "a" + "/" + context + "/";
        if (Log.getLogger("chef").isDebugEnabled()) {
            Log.debug("chef", "Entering allow add Assignment with resource string : " + resourceString);
            Log.debug("chef", "                                    context string : " + context);
        }
        return this.unlockCheck("asn.new", resourceString);
    }

    public boolean allowGetAssignment(String assignmentReference) {
        if (Log.getLogger("chef").isDebugEnabled()) {
            Log.debug("chef", "Entering allow get Assignment with reference string : " + assignmentReference);
        }
        return this.unlockCheck("asn.read", assignmentReference);
    }

    public boolean allowUpdateAssignment(String assignmentReference) {
        if (Log.getLogger("chef").isDebugEnabled()) {
            Log.debug("chef", "Entering allow update Assignment with resource string : " + assignmentReference);
        }
        return this.unlockCheck("asn.revise", assignmentReference);
    }

    public boolean allowRemoveAssignment(String assignmentReference) {
        if (Log.getLogger("chef").isDebugEnabled()) {
            Log.debug("chef", "Entering allow remove Assignment with resource string : " + assignmentReference);
        }
        return this.unlockCheck("asn.delete", assignmentReference);
    }

    public boolean allowGetAssignmentContent(String contentReference) {
        if (Log.getLogger("chef").isDebugEnabled()) {
            Log.debug("chef", "Entering allow get AssignmentContent with resource string : " + contentReference);
        }
        return this.unlockCheck("asn.read", contentReference);
    }

    public boolean allowUpdateAssignmentContent(String contentReference) {
        if (Log.getLogger("chef").isDebugEnabled()) {
            Log.debug("chef", "Entering allow update AssignmentContent with resource string : " + contentReference);
        }
        return this.unlockCheck("asn.revise", contentReference);
    }

    public boolean allowAddAssignmentContent(String context) {
        String resourceString = this.getAccessPoint(true) + "/" + "c" + "/" + context + "/";
        if (Log.getLogger("chef").isDebugEnabled()) {
            Log.debug("chef", "Entering allow add AssignmentContent with resource string : " + resourceString);
        }
        return this.unlockCheck("asn.new", resourceString);
    }

    public boolean allowRemoveAssignmentContent(String contentReference) {
        if (Log.getLogger("chef").isDebugEnabled()) {
            Log.debug("chef", "Entering allow remove assignment content with resource string : " + contentReference);
        }
        return this.unlockCheck("asn.delete", contentReference);
    }

    public boolean allowAddSubmission(String context) {
        String resourceString = this.getAccessPoint(true) + "/" + "s" + "/" + context + "/";
        if (Log.getLogger("chef").isDebugEnabled()) {
            Log.debug("chef", "Entering allow add Submission with resource string : " + resourceString);
        }
        return this.unlockCheck("asn.submit", resourceString);
    }

    public List allowAddSubmissionUsers(String assignmentReference) {
        return SecurityService.unlockUsers("asn.submit", assignmentReference);
    }

    public boolean allowGetSubmission(String submissionReference) {
        if (Log.getLogger("chef").isDebugEnabled()) {
            Log.debug("chef", "Entering allow get Submission with resource string : " + submissionReference);
        }
        return this.unlockCheck2("asn.submit", "asn.read", submissionReference);
    }

    public boolean allowUpdateSubmission(String submissionReference) {
        if (Log.getLogger("chef").isDebugEnabled()) {
            Log.debug("chef", "Entering allow update Submission with resource string : " + submissionReference);
        }
        return this.unlockCheck2("asn.submit", "asn.revise", submissionReference);
    }

    public boolean allowRemoveSubmission(String submissionReference) {
        if (Log.getLogger("chef").isDebugEnabled()) {
            Log.debug("chef", "Entering allow remove Submission with resource string : " + submissionReference);
        }
        return this.unlockCheck("asn.delete", submissionReference);
    }

    public Blob getGradesSpreadsheet(String ref) throws IdUnusedException, PermissionException {
        short cellNum;
        String typeGradesString = new String("grades/");
        String context = ref.substring(ref.indexOf(typeGradesString) + typeGradesString.length());
        short rowNum = 0;
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet("sheet 1");
        short s = rowNum;
        rowNum = (short)(rowNum + 1);
        HSSFRow row = sheet.createRow(s);
        row.createCell((short)0).setCellValue("Assignment Submission Excel File for group ");
        short s2 = rowNum;
        rowNum = (short)(rowNum + 1);
        row = sheet.createRow(s2);
        HSSFFont font = wb.createFont();
        font.setBoldweight((short)700);
        HSSFCellStyle style = wb.createCellStyle();
        style.setFont(font);
        short s3 = cellNum = 0;
        cellNum = (short)(cellNum + 1);
        HSSFCell cell = row.createCell(s3);
        cell.setCellStyle(style);
        cell.setCellValue("Student");
        short s4 = cellNum;
        cellNum = (short)(cellNum + 1);
        cell = row.createCell(s4);
        cell.setCellValue("Assignment");
        cell.setCellStyle(style);
        short s5 = cellNum;
        cellNum = (short)(cellNum + 1);
        cell = row.createCell(s5);
        cell.setCellValue("Grade");
        cell.setCellStyle(style);
        short s6 = cellNum;
        cellNum = (short)(cellNum + 1);
        cell = row.createCell(s6);
        cell.setCellValue("Max Grade");
        cell.setCellStyle(style);
        cell = row.createCell(cellNum);
        cell.setCellValue("Turn in Date");
        cell.setCellStyle(style);
        Iterator assignments = this.getAssignmentsForContext(context);
        while (assignments.hasNext()) {
            Assignment a = (Assignment)assignments.next();
            List members = this.allowAddSubmissionUsers(a.getReference());
            Iterator it = members.iterator();
            while (it.hasNext()) {
                short s7 = rowNum;
                rowNum = (short)(rowNum + 1);
                row = sheet.createRow(s7);
                cellNum = 0;
                User member = (User)it.next();
                try {
                    AssignmentSubmission s8 = this.getSubmission(a.getId(), member);
                    short s9 = cellNum;
                    cellNum = (short)(cellNum + 1);
                    row.createCell(s9).setCellValue(member.getDisplayName());
                    short s10 = cellNum;
                    cellNum = (short)(cellNum + 1);
                    row.createCell(s10).setCellValue(a.getTitle());
                    if (s8 != null && s8.getGraded() && s8.getGradeReleased()) {
                        short s11 = cellNum;
                        cellNum = (short)(cellNum + 1);
                        row.createCell(s11).setCellValue(s8.getGrade());
                    } else {
                        short s12 = cellNum;
                        cellNum = (short)(cellNum + 1);
                        row.createCell(s12).setCellValue("");
                    }
                    if (a.getContent().getTypeOfGrade() == 1) {
                        short s13 = cellNum;
                        cellNum = (short)(cellNum + 1);
                        row.createCell(s13).setCellValue("No Grade");
                    } else if (a.getContent().getTypeOfGrade() == 2) {
                        short s14 = cellNum;
                        cellNum = (short)(cellNum + 1);
                        row.createCell(s14).setCellValue("A+");
                    } else if (a.getContent().getTypeOfGrade() == 3) {
                        short s15 = cellNum;
                        cellNum = (short)(cellNum + 1);
                        row.createCell(s15).setCellValue((double)a.getContent().getMaxGradePoint());
                    } else if (a.getContent().getTypeOfGrade() == 4) {
                        short s16 = cellNum;
                        cellNum = (short)(cellNum + 1);
                        row.createCell(s16).setCellValue("Pass");
                    }
                    if (s8 != null && s8.getSubmitted()) {
                        Time sTime = s8.getTimeSubmitted();
                        if (sTime.after(a.getDueTime())) {
                            HSSFFont font2 = wb.createFont();
                            font2.setColor((short)10);
                            HSSFCellStyle style2 = wb.createCellStyle();
                            style2.setFont(font2);
                            short s17 = cellNum;
                            cellNum = (short)(cellNum + 1);
                            cell = row.createCell(s17);
                            cell.setCellValue(sTime.toStringLocalFull() + "- late");
                            cell.setCellStyle(style2);
                            continue;
                        }
                        short s18 = cellNum;
                        cellNum = (short)(cellNum + 1);
                        row.createCell(s18).setCellValue(sTime.toStringLocalFull());
                        continue;
                    }
                    short s19 = cellNum;
                    cellNum = (short)(cellNum + 1);
                    row.createCell(s19).setCellValue("");
                }
                catch (IdUnusedException e) {
                    throw new IdUnusedException(a.getId());
                }
                catch (PermissionException e) {
                    throw new PermissionException(UsageSessionService.getSessionUser().getId(), "asn.submit", a.getId());
                }
            }
        }
        Blob b = new Blob();
        try {
            wb.write(b.outputStream());
        }
        catch (IOException e) {
            Log.debug("chef", this + "Can not output the grade spread sheet. ");
        }
        return b;
    }

    /*
     * WARNING - void declaration
     */
    public Blob getSubmissionsZip(String ref) throws IdUnusedException, PermissionException {
        Blob b = new Blob();
        StringBuffer exceptionMessage = new StringBuffer();
        try {
            Assignment a = this.getAssignment(ref);
            try {
                ZipOutputStream out = new ZipOutputStream(b.outputStream());
                InputStream in = null;
                String root = a.getTitle() + "/";
                out.putNextEntry(new ZipEntry(root));
                out.closeEntry();
                Iterator submissions = this.getSubmissions(a);
                String submittedText = "";
                if (!submissions.hasNext()) {
                    exceptionMessage.append("There is no submission yet. ");
                }
                byte[] buf = new byte[1024];
                String outFilename = "outfile.zip";
                String submittersName = "";
                while (submissions.hasNext()) {
                    int len;
                    submittersName = root;
                    AssignmentSubmission s = (AssignmentSubmission)submissions.next();
                    User[] submitters = s.getSubmitters();
                    int i = 0;
                    while (i < submitters.length) {
                        if (i > 0) {
                            submittersName = submittersName.concat(", ");
                        }
                        submittersName = submittersName.concat(submitters[i].getDisplayName());
                        ++i;
                    }
                    submittersName = submittersName.concat("/");
                    submittedText = s.getSubmittedText();
                    out.putNextEntry(new ZipEntry(submittersName));
                    out.closeEntry();
                    ZipEntry textEntry = new ZipEntry(submittersName + "submittedText");
                    in = new Blob(submittedText.getBytes()).inputStream();
                    out.putNextEntry(textEntry);
                    while ((len = in.read(buf)) > 0) {
                        void var11_16;
                        out.write(buf, 0, (int)var11_16);
                    }
                    out.closeEntry();
                    in.close();
                    ReferenceVector attachments = s.getSubmittedAttachments();
                    int attachedUrlCount = 0;
                    int j = 0;
                    while (j < attachments.size()) {
                        Reference r = (Reference)attachments.get(j);
                        try {
                            ContentResource resource = ContentHostingService.getResource(r.getId());
                            String contentType = resource.getContentType();
                            byte[] content = resource.getContent();
                            ResourceProperties props = r.getProperties();
                            String displayName = props.getPropertyFormatted(props.getNamePropDisplayName());
                            if (contentType.equals("text/URL")) {
                                displayName = "attached_URL_" + attachedUrlCount;
                                ++attachedUrlCount;
                            }
                            ZipEntry attachmentEntry = new ZipEntry(submittersName + displayName);
                            in = new Blob(content).inputStream();
                            out.putNextEntry(attachmentEntry);
                            while ((len = in.read(buf)) > 0) {
                                out.write(buf, 0, len);
                            }
                            out.closeEntry();
                            in.close();
                        }
                        catch (PermissionException e) {
                            throw new PermissionException(UsageSessionService.getSessionUser().getId(), "content.read", r.getId());
                        }
                        catch (IdUnusedException e) {
                            throw new IdUnusedException(r.getId());
                        }
                        catch (TypeException e) {
                        }
                        catch (IOException e) {
                            Log.debug("chef", this + "Problem in creating the submission file. ");
                        }
                        ++j;
                    }
                }
                out.close();
            }
            catch (IOException e) {
                exceptionMessage.append("Can not establish the IO to create zip file. ");
                Log.debug("chef", "in bulk download " + e);
            }
        }
        catch (IdUnusedException e) {
            throw new IdUnusedException(ref);
        }
        catch (PermissionException e) {
            throw new PermissionException(UsageSessionService.getSessionUser().getId(), "asn.read", ref);
        }
        return b;
    }

    public String gradesSpreadsheetReference(String context, String assignmentId) {
        String s = "/assignment/grades/" + context;
        if (assignmentId != null) {
            s = s.concat("/" + assignmentId);
        }
        return s;
    }

    public String submissionsZipReference(String context, String assignmentId) {
        return "/assignment/submissions/" + context + "/" + assignmentId;
    }

    protected String getTimeString(Time t) {
        String retVal = "";
        if (t != null) {
            retVal = String.valueOf(t.getTime());
        }
        return retVal;
    }

    protected String getBoolString(boolean b) {
        if (b) {
            return "true";
        }
        return "false";
    }

    protected boolean getBool(String s) {
        boolean retVal = false;
        if (s != null && s.equalsIgnoreCase("true")) {
            retVal = true;
        }
        return retVal;
    }

    protected Time getTimeObject(String timeString) {
        Time aTime = null;
        if (timeString != "") {
            try {
                long longTime = Long.parseLong(timeString);
                aTime = new Time(longTime);
            }
            catch (Exception e) {
                Log.warn("chef", this + " Exception creating time object from xml file : " + e);
            }
        }
        return aTime;
    }

    protected String getGroupNameFromContext(String context) {
        String retVal = "";
        if (context != null) {
            int index = context.indexOf("group-");
            if (index != -1) {
                String[] parts = StringUtil.splitFirst(context, "-");
                if (parts.length > 1) {
                    retVal = parts[1];
                }
            } else {
                retVal = context;
            }
        }
        return retVal;
    }

    protected class AssignmentSubmissionCacheRefresher
    implements CacheRefresher {
        protected AssignmentSubmissionCacheRefresher() {
        }

        public Object refresh(Object key, Object oldValue, Event event) {
            String id = BaseAssignmentService.this.submissionId((String)key);
            AssignmentSubmission submission = BaseAssignmentService.this.m_submissionStorage.get(id);
            if (Log.getLogger("chef").isDebugEnabled()) {
                Log.debug("chef", this + ".refresh(): " + key + " : " + id);
            }
            return submission;
        }
    }

    protected class AssignmentContentCacheRefresher
    implements CacheRefresher {
        protected AssignmentContentCacheRefresher() {
        }

        public Object refresh(Object key, Object oldValue, Event event) {
            String id = BaseAssignmentService.this.contentId((String)key);
            AssignmentContent content = BaseAssignmentService.this.m_contentStorage.get(id);
            if (Log.getLogger("chef").isDebugEnabled()) {
                Log.debug("chef", this + ".refresh(): " + key + " : " + id);
            }
            return content;
        }
    }

    protected class AssignmentCacheRefresher
    implements CacheRefresher {
        protected AssignmentCacheRefresher() {
        }

        public Object refresh(Object key, Object oldValue, Event event) {
            String id = BaseAssignmentService.this.assignmentId((String)key);
            Assignment assignment = BaseAssignmentService.this.m_assignmentStorage.get(id);
            if (Log.getLogger("chef").isDebugEnabled()) {
                Log.debug("chef", this + ".refresh(): " + key + " : " + id);
            }
            return assignment;
        }
    }

    protected class AssignmentSubmissionStorageUser
    implements StorageUser {
        protected AssignmentSubmissionStorageUser() {
        }

        public Resource newContainer(String ref) {
            return null;
        }

        public Resource newContainer(Element element) {
            return null;
        }

        public Resource newContainer(Resource other) {
            return null;
        }

        public Resource newResource(Resource container, String id, Object[] others) {
            return new BaseAssignmentSubmission(id, (String)others[0], (String)others[1]);
        }

        public Resource newResource(Resource container, Element element) {
            return new BaseAssignmentSubmission(element);
        }

        public Resource newResource(Resource container, Resource other) {
            return new BaseAssignmentSubmission((AssignmentSubmission)other);
        }

        public Edit newContainerEdit(String ref) {
            return null;
        }

        public Edit newContainerEdit(Element element) {
            return null;
        }

        public Edit newContainerEdit(Resource other) {
            return null;
        }

        public Edit newResourceEdit(Resource container, String id, Object[] others) {
            BaseAssignmentSubmissionEdit e = new BaseAssignmentSubmissionEdit(id, (String)others[0], (String)others[1]);
            e.activate();
            return e;
        }

        public Edit newResourceEdit(Resource container, Element element) {
            BaseAssignmentSubmissionEdit e = new BaseAssignmentSubmissionEdit(element);
            e.activate();
            return e;
        }

        public Edit newResourceEdit(Resource container, Resource other) {
            BaseAssignmentSubmissionEdit e = new BaseAssignmentSubmissionEdit((AssignmentSubmission)other);
            e.activate();
            return e;
        }

        public Object[] storageFields(Resource r) {
            return null;
        }
    }

    protected class AssignmentContentStorageUser
    implements StorageUser {
        protected AssignmentContentStorageUser() {
        }

        public Resource newContainer(String ref) {
            return null;
        }

        public Resource newContainer(Element element) {
            return null;
        }

        public Resource newContainer(Resource other) {
            return null;
        }

        public Resource newResource(Resource container, String id, Object[] others) {
            return new BaseAssignmentContent(id, (String)others[0]);
        }

        public Resource newResource(Resource container, Element element) {
            return new BaseAssignmentContent(element);
        }

        public Resource newResource(Resource container, Resource other) {
            return new BaseAssignmentContent((AssignmentContent)other);
        }

        public Edit newContainerEdit(String ref) {
            return null;
        }

        public Edit newContainerEdit(Element element) {
            return null;
        }

        public Edit newContainerEdit(Resource other) {
            return null;
        }

        public Edit newResourceEdit(Resource container, String id, Object[] others) {
            BaseAssignmentContentEdit e = new BaseAssignmentContentEdit(id, (String)others[0]);
            e.activate();
            return e;
        }

        public Edit newResourceEdit(Resource container, Element element) {
            BaseAssignmentContentEdit e = new BaseAssignmentContentEdit(element);
            e.activate();
            return e;
        }

        public Edit newResourceEdit(Resource container, Resource other) {
            BaseAssignmentContentEdit e = new BaseAssignmentContentEdit((AssignmentContent)other);
            e.activate();
            return e;
        }

        public Object[] storageFields(Resource r) {
            return null;
        }
    }

    protected class AssignmentStorageUser
    implements StorageUser {
        protected AssignmentStorageUser() {
        }

        public Resource newContainer(String ref) {
            return null;
        }

        public Resource newContainer(Element element) {
            return null;
        }

        public Resource newContainer(Resource other) {
            return null;
        }

        public Resource newResource(Resource container, String id, Object[] others) {
            return new BaseAssignment(id, (String)others[0]);
        }

        public Resource newResource(Resource container, Element element) {
            return new BaseAssignment(element);
        }

        public Resource newResource(Resource container, Resource other) {
            return new BaseAssignment((Assignment)other);
        }

        public Edit newContainerEdit(String ref) {
            return null;
        }

        public Edit newContainerEdit(Element element) {
            return null;
        }

        public Edit newContainerEdit(Resource other) {
            return null;
        }

        public Edit newResourceEdit(Resource container, String id, Object[] others) {
            BaseAssignmentEdit e = new BaseAssignmentEdit(id, (String)others[0]);
            e.activate();
            return e;
        }

        public Edit newResourceEdit(Resource container, Element element) {
            BaseAssignmentEdit e = new BaseAssignmentEdit(element);
            e.activate();
            return e;
        }

        public Edit newResourceEdit(Resource container, Resource other) {
            BaseAssignmentEdit e = new BaseAssignmentEdit((Assignment)other);
            e.activate();
            return e;
        }

        public Object[] storageFields(Resource r) {
            return null;
        }
    }

    protected static interface AssignmentSubmissionStorage {
        public void open();

        public void close();

        public boolean check(String var1);

        public AssignmentSubmission get(String var1);

        public List getAll();

        public AssignmentSubmissionEdit put(String var1, String var2, String var3);

        public AssignmentSubmissionEdit edit(String var1);

        public void commit(AssignmentSubmissionEdit var1);

        public void cancel(AssignmentSubmissionEdit var1);

        public void remove(AssignmentSubmissionEdit var1);
    }

    protected static interface AssignmentContentStorage {
        public void open();

        public void close();

        public boolean check(String var1);

        public AssignmentContent get(String var1);

        public List getAll();

        public AssignmentContentEdit put(String var1, String var2);

        public AssignmentContentEdit edit(String var1);

        public void commit(AssignmentContentEdit var1);

        public void cancel(AssignmentContentEdit var1);

        public void remove(AssignmentContentEdit var1);
    }

    protected static interface AssignmentStorage {
        public void open();

        public void close();

        public boolean check(String var1);

        public Assignment get(String var1);

        public List getAll();

        public AssignmentEdit put(String var1, String var2);

        public AssignmentEdit edit(String var1);

        public void commit(AssignmentEdit var1);

        public void cancel(AssignmentEdit var1);

        public void remove(AssignmentEdit var1);
    }

    public class BaseAssignmentSubmissionEdit
    extends BaseAssignmentSubmission
    implements AssignmentSubmissionEdit,
    SessionStateBindingListener {
        protected String m_event = null;
        protected boolean m_active = false;

        public BaseAssignmentSubmissionEdit(AssignmentSubmission assignmentSubmission) {
            super(assignmentSubmission);
        }

        public BaseAssignmentSubmissionEdit(String id, String context, String assignmentId) {
            super(id, context, assignmentId);
        }

        public BaseAssignmentSubmissionEdit(Element el) {
            super(el);
        }

        protected void finalize() {
            if (this.m_active) {
                BaseAssignmentService.this.cancelEdit(this);
            }
        }

        public void setContext(String context) {
            this.m_context = context;
        }

        public void setAssignment(Assignment assignment) {
            this.m_assignment = assignment != null ? assignment.getId() : "";
        }

        public void setSubmitted(boolean submitted) {
            this.m_submitted = submitted;
        }

        public void addSubmitter(User submitter) {
            if (submitter != null) {
                this.m_submitters.add(submitter.getId());
            }
        }

        public void removeSubmitter(User submitter) {
            if (submitter != null) {
                this.m_submitters.remove(submitter.getId());
            }
        }

        public void setTimeSubmitted(Time value) {
            this.m_timeSubmitted = value;
        }

        public void setGradeReleased(boolean released) {
            this.m_gradeReleased = released;
        }

        public void setGrade(String grade) {
            this.m_grade = grade;
        }

        public void setSubmittedText(String value) {
            this.m_submittedText = value;
        }

        public void addSubmittedAttachment(Reference attachment) {
            if (attachment != null) {
                this.m_submittedAttachments.add(attachment);
            }
        }

        public void removeSubmittedAttachment(Reference attachment) {
            if (attachment != null) {
                this.m_submittedAttachments.remove(attachment);
            }
        }

        public void clearSubmittedAttachments() {
            this.m_submittedAttachments.clear();
        }

        public void setFeedbackComment(String value) {
            this.m_feedbackComment = value;
        }

        public void setFeedbackText(String value) {
            this.m_feedbackText = value;
        }

        public void addFeedbackAttachment(Reference attachment) {
            if (attachment != null) {
                this.m_feedbackAttachments.add(attachment);
            }
        }

        public void removeFeedbackAttachment(Reference attachment) {
            if (attachment != null) {
                this.m_feedbackAttachments.remove(attachment);
            }
        }

        public void clearFeedbackAttachments() {
            this.m_feedbackAttachments.clear();
        }

        public void setReturned(boolean value) {
            this.m_returned = value;
        }

        public void setGraded(boolean value) {
            this.m_graded = value;
        }

        public void setTimeReturned(Time timeReturned) {
            this.m_timeReturned = timeReturned;
        }

        public void setHonorPledgeFlag(boolean honorPledgeFlag) {
            this.m_honorPledgeFlag = honorPledgeFlag;
        }

        public void setTimeLastModified(Time lastmod) {
            if (lastmod != null) {
                this.m_timeLastModified = lastmod;
            }
        }

        protected void set(AssignmentSubmission assignmentSubmission) {
            this.setAll(assignmentSubmission);
        }

        protected String getEvent() {
            return this.m_event;
        }

        protected void setEvent(String event) {
            this.m_event = event;
        }

        public ResourcePropertiesEdit getPropertiesEdit() {
            return this.m_properties;
        }

        protected void activate() {
            this.m_active = true;
        }

        public boolean isActiveEdit() {
            return this.m_active;
        }

        protected void closeEdit() {
            this.m_active = false;
        }

        public void valueBound(String sessionStateKey, String attributeName) {
        }

        public void valueUnbound(String sessionStateKey, String attributeName) {
            if (Log.getLogger("chef").isDebugEnabled()) {
                Log.debug("chef", this + ".valueUnbound()");
            }
            if (this.m_active) {
                BaseAssignmentService.this.cancelEdit(this);
            }
        }
    }

    public class BaseAssignmentSubmission
    implements AssignmentSubmission {
        protected final String STATUS_DRAFT = "Drafted";
        protected final String STATUS_SUBMITTED = "Submitted";
        protected final String STATUS_RETURNED = "Returned";
        protected final String STATUS_GRADED = "Graded";
        protected ResourcePropertiesEdit m_properties;
        protected String m_id;
        protected String m_assignment;
        protected String m_context;
        protected FlexStringArray m_submitters;
        protected Time m_timeSubmitted;
        protected Time m_timeReturned;
        protected Time m_timeLastModified;
        protected ReferenceVector m_submittedAttachments;
        protected ReferenceVector m_feedbackAttachments;
        protected String m_submittedText;
        protected String m_feedbackComment;
        protected String m_feedbackText;
        protected String m_grade;
        protected boolean m_submitted;
        protected boolean m_returned;
        protected boolean m_graded;
        protected boolean m_gradeReleased;
        protected boolean m_honorPledgeFlag;

        public BaseAssignmentSubmission(AssignmentSubmission submission) {
            this.setAll(submission);
        }

        public BaseAssignmentSubmission(String id, String context, String assignId) {
            this.m_id = id;
            this.m_context = context;
            this.m_assignment = assignId;
            this.m_properties = new BaseResourcePropertiesEdit();
            BaseAssignmentService.this.addLiveProperties(this.m_properties);
            this.m_submitters = new FlexStringArray();
            this.m_feedbackAttachments = new ReferenceVector();
            this.m_submittedAttachments = new ReferenceVector();
            this.m_submitted = false;
            this.m_returned = false;
            this.m_graded = false;
            this.m_gradeReleased = false;
            this.m_submittedText = "";
            this.m_feedbackComment = "";
            this.m_feedbackText = "";
            this.m_grade = "";
            this.m_timeLastModified = new Time();
            User currentUser = UsageSessionService.getSessionUser();
            this.m_submitters.add(currentUser.getId());
        }

        public BaseAssignmentSubmission(Element el) {
            int numAttributes = 0;
            Object bool = null;
            String intString = null;
            String attributeString = null;
            String tempString = null;
            Reference tempReference = null;
            if (Log.getLogger("chef").isDebugEnabled()) {
                Log.debug("chef", "ASSIGNMENT : BASE SERVICE : BASE SUB : ENTERING STORAGE CONSTRUCTOR");
            }
            this.m_id = el.getAttribute("id");
            this.m_context = el.getAttribute("context");
            this.m_grade = el.getAttribute("grade");
            this.m_assignment = el.getAttribute("assignment");
            this.m_timeSubmitted = BaseAssignmentService.this.getTimeObject(el.getAttribute("datesubmitted"));
            this.m_timeReturned = BaseAssignmentService.this.getTimeObject(el.getAttribute("datereturned"));
            this.m_assignment = el.getAttribute("assignment");
            this.m_timeLastModified = BaseAssignmentService.this.getTimeObject(el.getAttribute("lastmod"));
            this.m_submitted = BaseAssignmentService.this.getBool(el.getAttribute("submitted"));
            this.m_returned = BaseAssignmentService.this.getBool(el.getAttribute("returned"));
            this.m_graded = BaseAssignmentService.this.getBool(el.getAttribute("graded"));
            this.m_gradeReleased = BaseAssignmentService.this.getBool(el.getAttribute("gradereleased"));
            this.m_honorPledgeFlag = BaseAssignmentService.this.getBool(el.getAttribute("pledgeflag"));
            this.m_submittedText = Xml.decodeAttribute(el, "submittedtext");
            this.m_feedbackComment = Xml.decodeAttribute(el, "feedbackcomment");
            this.m_feedbackText = Xml.decodeAttribute(el, "feedbacktext");
            this.m_submitters = new FlexStringArray();
            if (Log.getLogger("chef").isDebugEnabled()) {
                Log.debug("chef", "ASSIGNMENT : BASE SERVICE : BASE SUB : CONSTRUCTOR : Reading submitters : ");
            }
            intString = el.getAttribute("numberofsubmitters");
            try {
                numAttributes = Integer.parseInt(intString);
                int x = 0;
                while (x < numAttributes) {
                    attributeString = "submitter" + x;
                    tempString = el.getAttribute(attributeString);
                    if (tempString != null) {
                        this.m_submitters.add(tempString);
                    }
                    ++x;
                }
            }
            catch (Exception e) {
                Log.warn("chef", "ASSIGNMENT : BASE SERVICE : BASE SUB : CONSTRUCTOR : Exception reading submitters : " + e);
            }
            this.m_feedbackAttachments = new ReferenceVector();
            intString = el.getAttribute("numberoffeedbackattachments");
            if (Log.getLogger("chef").isDebugEnabled()) {
                Log.debug("chef", "ASSIGNMENT : BASE SERVICE : BASE SUB : CONSTRUCTOR : num feedback attachments : " + intString);
            }
            try {
                numAttributes = Integer.parseInt(intString);
                int x = 0;
                while (x < numAttributes) {
                    attributeString = "feedbackattachment" + x;
                    tempString = el.getAttribute(attributeString);
                    if (tempString != null) {
                        tempReference = new Reference(tempString);
                        this.m_feedbackAttachments.add(tempReference);
                        if (Log.getLogger("chef").isDebugEnabled()) {
                            Log.debug("chef", "ASSIGNMENT : BASE SERVICE : BASE SUB : CONSTRUCTOR : " + attributeString + " : " + tempString);
                        }
                    }
                    ++x;
                }
            }
            catch (Exception e) {
                Log.warn("chef", "ASSIGNMENT : BASE SERVICE : BASE SUB : CONSTRUCTOR : Exception reading feedback attachments : " + e);
            }
            this.m_submittedAttachments = new ReferenceVector();
            intString = el.getAttribute("numberofsubmittedattachments");
            if (Log.getLogger("chef").isDebugEnabled()) {
                Log.debug("chef", "ASSIGNMENT : BASE SERVICE : BASE SUB : CONSTRUCTOR : num submitted attachments : " + intString);
            }
            try {
                numAttributes = Integer.parseInt(intString);
                int x = 0;
                while (x < numAttributes) {
                    attributeString = "submittedattachment" + x;
                    tempString = el.getAttribute(attributeString);
                    if (tempString != null) {
                        tempReference = new Reference(tempString);
                        this.m_submittedAttachments.add(tempReference);
                        if (Log.getLogger("chef").isDebugEnabled()) {
                            Log.debug("chef", "ASSIGNMENT : BASE SERVICE : BASE SUB : CONSTRUCTOR : " + attributeString + " : " + tempString);
                        }
                    }
                    ++x;
                }
            }
            catch (Exception e) {
                Log.warn("chef", "ASSIGNMENT : BASE SERVICE : BASE SUB : CONSTRUCTOR : Exception reading submitted attachments : " + e);
            }
            NodeList children = el.getChildNodes();
            int length = children.getLength();
            int i = 0;
            while (i < length) {
                Node child = children.item(i);
                if (child.getNodeType() == 1) {
                    Element element = (Element)child;
                    if (element.getTagName().equals("properties")) {
                        this.m_properties = new BaseResourcePropertiesEdit(element);
                    } else if (element.getTagName().equals("submittedtext")) {
                        if (element.getChildNodes() != null && element.getChildNodes().item(0) != null) {
                            this.m_submittedText = element.getChildNodes().item(0).getNodeValue();
                            if (Log.getLogger("chef").isDebugEnabled()) {
                                Log.debug("chef", "ASSIGNMENT : BASE SERVICE : BASE SUB : CONSTRUCTOR : submittedtext : " + this.m_submittedText);
                            }
                        }
                        if (this.m_submittedText == null) {
                            this.m_submittedText = "";
                        }
                    } else if (element.getTagName().equals("feedbackcomment")) {
                        if (element.getChildNodes() != null && element.getChildNodes().item(0) != null) {
                            this.m_feedbackComment = element.getChildNodes().item(0).getNodeValue();
                            if (Log.getLogger("chef").isDebugEnabled()) {
                                Log.debug("chef", "ASSIGNMENT : BASE SERVICE : BASE SUB : CONSTRUCTOR : feedbackcomment : " + this.m_feedbackComment);
                            }
                        }
                        if (this.m_feedbackComment == null) {
                            this.m_feedbackComment = "";
                        }
                    } else if (element.getTagName().equals("feedbacktext")) {
                        if (element.getChildNodes() != null && element.getChildNodes().item(0) != null) {
                            this.m_feedbackText = element.getChildNodes().item(0).getNodeValue();
                            if (Log.getLogger("chef").isDebugEnabled()) {
                                Log.debug("chef", "ASSIGNMENT : BASE SERVICE : BASE SUB : CONSTRUCTOR : FEEDBACK TEXT : " + this.m_feedbackText);
                            }
                        }
                        if (this.m_feedbackText == null) {
                            this.m_feedbackText = "";
                        }
                    }
                }
                ++i;
            }
            if (Log.getLogger("chef").isDebugEnabled()) {
                Log.debug("chef", "ASSIGNMENT : BASE SERVICE : BASE SUB : LEAVING STORAGE CONSTRUCTOR");
            }
        }

        public Element toXml(Document doc, Stack stack) {
            if (Log.getLogger("chef").isDebugEnabled()) {
                Log.debug("chef", "ASSIGNMENT : BASE SERVICE : BASE ASSIGNMENT : ENTERING TOXML");
            }
            Element submission = doc.createElement("submission");
            if (stack.isEmpty()) {
                doc.appendChild(submission);
            } else {
                ((Element)stack.peek()).appendChild(submission);
            }
            stack.push(submission);
            String numItemsString = null;
            String attributeString = null;
            String itemString = null;
            Reference tempReference = null;
            submission.setAttribute("id", this.m_id);
            submission.setAttribute("context", this.m_context);
            submission.setAttribute("grade", this.m_grade);
            submission.setAttribute("assignment", this.m_assignment);
            submission.setAttribute("datesubmitted", BaseAssignmentService.this.getTimeString(this.m_timeSubmitted));
            submission.setAttribute("datereturned", BaseAssignmentService.this.getTimeString(this.m_timeReturned));
            submission.setAttribute("lastmod", BaseAssignmentService.this.getTimeString(this.m_timeLastModified));
            submission.setAttribute("submitted", BaseAssignmentService.this.getBoolString(this.m_submitted));
            submission.setAttribute("returned", BaseAssignmentService.this.getBoolString(this.m_returned));
            submission.setAttribute("graded", BaseAssignmentService.this.getBoolString(this.m_graded));
            submission.setAttribute("gradereleased", BaseAssignmentService.this.getBoolString(this.m_gradeReleased));
            submission.setAttribute("pledgeflag", BaseAssignmentService.this.getBoolString(this.m_honorPledgeFlag));
            if (Log.getLogger("chef").isDebugEnabled()) {
                Log.debug("chef", "ASSIGNMENT : BASE SERVICE : BASE ASSIGNMENT : SAVED REGULAR PROPERTIES");
            }
            numItemsString = "" + this.m_submitters.size();
            submission.setAttribute("numberofsubmitters", numItemsString);
            int x = 0;
            while (x < this.m_submitters.size()) {
                attributeString = "submitter" + x;
                itemString = this.m_submitters.get(x);
                if (itemString != null) {
                    submission.setAttribute(attributeString, itemString);
                }
                ++x;
            }
            if (Log.getLogger("chef").isDebugEnabled()) {
                Log.debug("chef", "ASSIGNMENT : BASE SERVICE : BASE ASSIGNMENT : SAVED SUBMITTERS");
            }
            numItemsString = "" + this.m_feedbackAttachments.size();
            submission.setAttribute("numberoffeedbackattachments", numItemsString);
            if (Log.getLogger("chef").isDebugEnabled()) {
                Log.debug("chef", "DB : DbCachedStorage : DbCachedAssignmentSubmission : entering fb attach loop : size : " + numItemsString);
            }
            int x2 = 0;
            while (x2 < this.m_feedbackAttachments.size()) {
                attributeString = "feedbackattachment" + x2;
                tempReference = (Reference)this.m_feedbackAttachments.get(x2);
                itemString = tempReference.getReference();
                if (itemString != null) {
                    submission.setAttribute(attributeString, itemString);
                }
                ++x2;
            }
            if (Log.getLogger("chef").isDebugEnabled()) {
                Log.debug("chef", "ASSIGNMENT : BASE SERVICE : BASE ASSIGNMENT : SAVED FEEDBACK ATTACHMENTS");
            }
            numItemsString = "" + this.m_submittedAttachments.size();
            submission.setAttribute("numberofsubmittedattachments", numItemsString);
            int x3 = 0;
            while (x3 < this.m_submittedAttachments.size()) {
                attributeString = "submittedattachment" + x3;
                tempReference = (Reference)this.m_submittedAttachments.get(x3);
                itemString = tempReference.getReference();
                if (itemString != null) {
                    submission.setAttribute(attributeString, itemString);
                }
                ++x3;
            }
            if (Log.getLogger("chef").isDebugEnabled()) {
                Log.debug("chef", "ASSIGNMENT : BASE SERVICE : BASE ASSIGNMENT : SAVED SUBMITTED ATTACHMENTS");
            }
            this.m_properties.toXml(doc, stack);
            stack.pop();
            Xml.encodeAttribute(submission, "submittedtext", this.m_submittedText);
            Xml.encodeAttribute(submission, "feedbackcomment", this.m_feedbackComment);
            Xml.encodeAttribute(submission, "feedbacktext", this.m_feedbackText);
            if (Log.getLogger("chef").isDebugEnabled()) {
                Log.debug("chef", "ASSIGNMENT : BASE SERVICE : BASE ASSIGNMENT : LEAVING TOXML");
            }
            return submission;
        }

        protected void setAll(AssignmentSubmission submission) {
            this.m_id = submission.getId();
            this.m_context = submission.getContext();
            this.m_assignment = submission.getAssignmentId();
            this.m_grade = submission.getGrade();
            this.m_submitters = submission.getSubmitterIds();
            this.m_submitted = submission.getSubmitted();
            this.m_timeSubmitted = submission.getTimeSubmitted();
            this.m_timeReturned = submission.getTimeReturned();
            this.m_timeLastModified = submission.getTimeLastModified();
            this.m_submittedAttachments = submission.getSubmittedAttachments();
            this.m_feedbackAttachments = submission.getFeedbackAttachments();
            this.m_submittedText = submission.getSubmittedText();
            this.m_feedbackComment = submission.getFeedbackComment();
            this.m_feedbackText = submission.getFeedbackText();
            this.m_returned = submission.getReturned();
            this.m_graded = submission.getGraded();
            this.m_gradeReleased = submission.getGradeReleased();
            this.m_honorPledgeFlag = submission.getHonorPledgeFlag();
            this.m_properties = new BaseResourcePropertiesEdit();
            this.m_properties.addAll(submission.getProperties());
        }

        public String getUrl() {
            return BaseAssignmentService.this.getAccessPoint(false) + "/" + "s" + "/" + this.m_context + "/" + this.m_id;
        }

        public String getReference() {
            return BaseAssignmentService.this.submissionReference(this.m_context, this.m_id, this.m_assignment);
        }

        public String getId() {
            return this.m_id;
        }

        public ResourceProperties getProperties() {
            return this.m_properties;
        }

        public String getContext() {
            return this.m_context;
        }

        public Assignment getAssignment() {
            Assignment retVal = null;
            if (this.m_assignment != null) {
                retVal = BaseAssignmentService.this.m_assignmentStorage.get(this.m_assignment);
            }
            return retVal;
        }

        public String getAssignmentId() {
            return this.m_assignment;
        }

        public boolean getSubmitted() {
            return this.m_submitted;
        }

        public User[] getSubmitters() {
            User[] retVal = new User[this.m_submitters.size()];
            int x = 0;
            while (x < this.m_submitters.size()) {
                try {
                    retVal[x] = UserDirectoryService.getUser(this.m_submitters.get(x));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++x;
            }
            return retVal;
        }

        public FlexStringArray getSubmitterIds() {
            return this.m_submitters;
        }

        public Time getTimeSubmitted() {
            return this.m_timeSubmitted;
        }

        public boolean getGradeReleased() {
            return this.m_gradeReleased;
        }

        public String getGrade() {
            return this.m_grade;
        }

        public Time getTimeLastModified() {
            return this.m_timeLastModified;
        }

        public String getSubmittedText() {
            return this.m_submittedText;
        }

        public ReferenceVector getSubmittedAttachments() {
            return this.m_submittedAttachments;
        }

        public String getFeedbackComment() {
            return this.m_feedbackComment;
        }

        public String getFeedbackText() {
            return this.m_feedbackText;
        }

        public ReferenceVector getFeedbackAttachments() {
            return this.m_feedbackAttachments;
        }

        public boolean getReturned() {
            return this.m_returned;
        }

        public boolean getGraded() {
            return this.m_graded;
        }

        public Time getTimeReturned() {
            return this.m_timeReturned;
        }

        public boolean getHonorPledgeFlag() {
            return this.m_honorPledgeFlag;
        }

        public String getStatus() {
            String retVal = null;
            retVal = this.m_submitted ? (this.m_graded && this.m_gradeReleased ? "Graded" : (this.m_returned ? "Returned" : "Submitted")) : "Drafted";
            return retVal;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof AssignmentSubmission)) {
                return false;
            }
            return ((AssignmentSubmission)obj).getId().equals(this.getId());
        }

        public int compareTo(Object obj) {
            if (!(obj instanceof AssignmentSubmission)) {
                throw new ClassCastException();
            }
            if (obj == this) {
                return 0;
            }
            int compare = this.getTimeSubmitted().toString().compareTo(((AssignmentSubmission)obj).getTimeSubmitted().toString());
            if (compare == 0) {
                compare = this.getId().compareTo(((AssignmentSubmission)obj).getId());
            }
            return compare;
        }
    }

    public class BaseAssignmentContentEdit
    extends BaseAssignmentContent
    implements AttachmentContainer,
    AssignmentContentEdit,
    SessionStateBindingListener {
        protected String m_event = null;
        protected boolean m_active = false;

        public BaseAssignmentContentEdit(AssignmentContent assignmentContent) {
            super(assignmentContent);
        }

        public BaseAssignmentContentEdit(String id, String context) {
            super(id, context);
        }

        public BaseAssignmentContentEdit(Element el) {
            super(el);
        }

        protected void finalize() {
            if (this.m_active) {
                BaseAssignmentService.this.cancelEdit(this);
            }
        }

        public void addAttachment(Reference ref) {
            if (ref != null) {
                this.m_attachments.add(ref);
            }
        }

        public void removeAttachment(Reference ref) {
            if (ref != null) {
                this.m_attachments.remove(ref);
            }
        }

        public void replaceAttachments(ReferenceVector attachments) {
            this.m_attachments = attachments;
        }

        public void clearAttachments() {
            this.m_attachments.clear();
        }

        public void setTitle(String title) {
            this.m_title = title;
        }

        public void setInstructions(String instructions) {
            this.m_instructions = instructions;
        }

        public void setContext(String context) {
            this.m_context = context;
        }

        public void setTypeOfSubmission(int type) {
            this.m_typeOfSubmission = type;
        }

        public void setTypeOfGrade(int gradeType) {
            this.m_typeOfGrade = gradeType;
        }

        public void setMaxGradePoint(int maxPoints) {
            this.m_maxGradePoint = maxPoints;
        }

        public void setGroupProject(boolean groupProject) {
            this.m_groupProject = groupProject;
        }

        public void setIndividuallyGraded(boolean individGraded) {
            this.m_individuallyGraded = individGraded;
        }

        public void setReleaseGrades(boolean release) {
            this.m_releaseGrades = release;
        }

        public void setHonorPledge(int pledgeType) {
            this.m_honorPledge = pledgeType;
        }

        public void setAllowAttachments(boolean allow) {
            this.m_allowAttachments = allow;
        }

        public void addAuthor(User author) {
            if (author != null) {
                this.m_authors.add(author.getId());
            }
        }

        public void removeAuthor(User author) {
            if (author != null) {
                this.m_authors.remove(author.getId());
            }
        }

        public void setTimeLastModified(Time lastmod) {
            if (lastmod != null) {
                this.m_timeLastModified = lastmod;
            }
        }

        protected void set(AssignmentContent assignmentContent) {
            this.setAll(assignmentContent);
        }

        protected String getEvent() {
            return this.m_event;
        }

        protected void setEvent(String event) {
            this.m_event = event;
        }

        public ResourcePropertiesEdit getPropertiesEdit() {
            return this.m_properties;
        }

        protected void activate() {
            this.m_active = true;
        }

        public boolean isActiveEdit() {
            return this.m_active;
        }

        protected void closeEdit() {
            this.m_active = false;
        }

        public void valueBound(String sessionStateKey, String attributeName) {
        }

        public void valueUnbound(String sessionStateKey, String attributeName) {
            if (Log.getLogger("chef").isDebugEnabled()) {
                Log.debug("chef", this + ".valueUnbound()");
            }
            if (this.m_active) {
                BaseAssignmentService.this.cancelEdit(this);
            }
        }
    }

    public class BaseAssignmentContent
    implements AssignmentContent {
        protected ResourcePropertiesEdit m_properties;
        protected String m_id;
        protected String m_context;
        protected ReferenceVector m_attachments;
        protected FlexStringArray m_authors;
        protected String m_title;
        protected String m_instructions;
        protected int m_honorPledge;
        protected int m_typeOfSubmission;
        protected int m_typeOfGrade;
        protected int m_maxGradePoint;
        protected boolean m_groupProject;
        protected boolean m_individuallyGraded;
        protected boolean m_releaseGrades;
        protected boolean m_allowAttachments;
        protected Time m_timeCreated;
        protected Time m_timeLastModified;

        public BaseAssignmentContent(AssignmentContent content) {
            this.setAll(content);
        }

        public BaseAssignmentContent(String id, String context) {
            this.m_id = id;
            this.m_context = context;
            this.m_properties = new BaseResourcePropertiesEdit();
            BaseAssignmentService.this.addLiveProperties(this.m_properties);
            this.m_authors = new FlexStringArray();
            this.m_attachments = new ReferenceVector();
            this.m_title = "";
            this.m_instructions = "";
            this.m_honorPledge = -1;
            this.m_typeOfSubmission = -1;
            this.m_typeOfGrade = -1;
            this.m_maxGradePoint = 0;
            this.m_timeCreated = new Time();
            this.m_timeLastModified = new Time();
        }

        public BaseAssignmentContent(Element el) {
            int numAttributes = 0;
            Object bool = null;
            String intString = null;
            String attributeString = null;
            String tempString = null;
            Reference tempReference = null;
            if (Log.getLogger("chef").isDebugEnabled()) {
                Log.debug("chef", "DB : DbCachedAssignmentContent : Entering read");
            }
            this.m_id = el.getAttribute("id");
            this.m_context = el.getAttribute("context");
            this.m_title = el.getAttribute("title");
            this.m_groupProject = BaseAssignmentService.this.getBool(el.getAttribute("groupproject"));
            this.m_individuallyGraded = BaseAssignmentService.this.getBool(el.getAttribute("indivgraded"));
            this.m_releaseGrades = BaseAssignmentService.this.getBool(el.getAttribute("releasegrades"));
            this.m_allowAttachments = BaseAssignmentService.this.getBool(el.getAttribute("allowattach"));
            this.m_timeCreated = BaseAssignmentService.this.getTimeObject(el.getAttribute("datecreated"));
            this.m_timeLastModified = BaseAssignmentService.this.getTimeObject(el.getAttribute("lastmod"));
            this.m_instructions = Xml.decodeAttribute(el, "instructions");
            try {
                this.m_honorPledge = Integer.parseInt(el.getAttribute("honorpledge"));
            }
            catch (Exception e) {
                Log.warn("chef", this + " Exception parsing honor pledge int from xml file string : " + e);
            }
            try {
                this.m_typeOfSubmission = Integer.parseInt(el.getAttribute("submissiontype"));
            }
            catch (Exception e) {
                Log.warn("chef", this + " Exception parsing submission type int from xml file string : " + e);
            }
            try {
                this.m_typeOfGrade = Integer.parseInt(el.getAttribute("typeofgrade"));
            }
            catch (Exception e) {
                Log.warn("chef", this + " Exception parsing grade type int from xml file string : " + e);
            }
            try {
                this.m_maxGradePoint = Integer.parseInt(el.getAttribute("maxgradepoint"));
            }
            catch (Exception e) {
                Log.warn("chef", this + " Exception parsing maxgradepoint int from xml file string : " + e);
            }
            this.m_authors = new FlexStringArray();
            intString = el.getAttribute("numberofauthors");
            try {
                numAttributes = Integer.parseInt(intString);
                int x = 0;
                while (x < numAttributes) {
                    attributeString = "author" + x;
                    tempString = el.getAttribute(attributeString);
                    if (tempString != null) {
                        this.m_authors.add(tempString);
                    }
                    ++x;
                }
            }
            catch (Exception e) {
                Log.warn("chef", "DB : DbCachedContent : Exception reading authors : " + e);
            }
            this.m_attachments = new ReferenceVector();
            if (Log.getLogger("chef").isDebugEnabled()) {
                Log.debug("chef", "DB : DbCachedContent : Reading attachments : ");
            }
            intString = el.getAttribute("numberofattachments");
            if (Log.getLogger("chef").isDebugEnabled()) {
                Log.debug("chef", "DB : DbCachedContent : num attachments : " + intString);
            }
            try {
                numAttributes = Integer.parseInt(intString);
                int x = 0;
                while (x < numAttributes) {
                    attributeString = "attachment" + x;
                    tempString = el.getAttribute(attributeString);
                    if (tempString != null) {
                        tempReference = new Reference(tempString);
                        this.m_attachments.add(tempReference);
                        if (Log.getLogger("chef").isDebugEnabled()) {
                            Log.debug("chef", "DB : DbCachedContent : " + attributeString + " : " + tempString);
                        }
                    }
                    ++x;
                }
            }
            catch (Exception e) {
                Log.warn("chef", "DB : DbCachedContent : Exception reading attachments : " + e);
            }
            NodeList children = el.getChildNodes();
            int length = children.getLength();
            int i = 0;
            while (i < length) {
                Node child = children.item(i);
                if (child.getNodeType() == 1) {
                    Element element = (Element)child;
                    if (element.getTagName().equals("properties")) {
                        this.m_properties = new BaseResourcePropertiesEdit(element);
                    } else if (element.getTagName().equals("instructions")) {
                        if (element.getChildNodes() != null && element.getChildNodes().item(0) != null) {
                            this.m_instructions = element.getChildNodes().item(0).getNodeValue();
                            if (Log.getLogger("chef").isDebugEnabled()) {
                                Log.debug("chef", "XML : DbCachedAssignmentContent : instructions : " + this.m_instructions);
                            }
                        }
                        if (this.m_instructions == null) {
                            this.m_instructions = "";
                        }
                    }
                }
                ++i;
            }
            if (Log.getLogger("chef").isDebugEnabled()) {
                Log.debug("chef", "ASSIGNMENT : BASE SERVICE : BASE CONTENT : LEAVING STORAGE CONSTRUTOR");
            }
        }

        public Element toXml(Document doc, Stack stack) {
            if (Log.getLogger("chef").isDebugEnabled()) {
                Log.debug("chef", "ASSIGNMENT : BASE SERVICE : BASE ASSIGNMENT : ENTERING TOXML");
            }
            Element content = doc.createElement("content");
            if (stack.isEmpty()) {
                doc.appendChild(content);
            } else {
                ((Element)stack.peek()).appendChild(content);
            }
            stack.push(content);
            String numItemsString = null;
            String attributeString = null;
            String itemString = null;
            Reference tempReference = null;
            content.setAttribute("id", this.m_id);
            content.setAttribute("context", this.m_context);
            content.setAttribute("title", this.m_title);
            content.setAttribute("groupproject", BaseAssignmentService.this.getBoolString(this.m_groupProject));
            content.setAttribute("indivgraded", BaseAssignmentService.this.getBoolString(this.m_individuallyGraded));
            content.setAttribute("releasegrades", BaseAssignmentService.this.getBoolString(this.m_releaseGrades));
            content.setAttribute("allowattach", BaseAssignmentService.this.getBoolString(this.m_allowAttachments));
            content.setAttribute("honorpledge", String.valueOf(this.m_honorPledge));
            content.setAttribute("submissiontype", String.valueOf(this.m_typeOfSubmission));
            content.setAttribute("typeofgrade", String.valueOf(this.m_typeOfGrade));
            content.setAttribute("maxgradepoint", String.valueOf(this.m_maxGradePoint));
            content.setAttribute("datecreated", BaseAssignmentService.this.getTimeString(this.m_timeCreated));
            content.setAttribute("lastmod", BaseAssignmentService.this.getTimeString(this.m_timeLastModified));
            if (Log.getLogger("chef").isDebugEnabled()) {
                Log.debug("chef", "ASSIGNMENT : BASE SERVICE : BASE CONTENT : TOXML : SAVED REGULAR PROPERTIES");
            }
            numItemsString = "" + this.m_authors.size();
            content.setAttribute("numberofauthors", numItemsString);
            int x = 0;
            while (x < this.m_authors.size()) {
                attributeString = "author" + x;
                itemString = this.m_authors.get(x);
                if (itemString != null) {
                    content.setAttribute(attributeString, itemString);
                }
                ++x;
            }
            if (Log.getLogger("chef").isDebugEnabled()) {
                Log.debug("chef", "ASSIGNMENT : BASE SERVICE : BASE CONTENT : TOXML : SAVED AUTHORS");
            }
            numItemsString = "" + this.m_attachments.size();
            content.setAttribute("numberofattachments", numItemsString);
            int x2 = 0;
            while (x2 < this.m_attachments.size()) {
                attributeString = "attachment" + x2;
                tempReference = (Reference)this.m_attachments.get(x2);
                itemString = tempReference.getReference();
                if (itemString != null) {
                    content.setAttribute(attributeString, itemString);
                }
                ++x2;
            }
            this.m_properties.toXml(doc, stack);
            if (Log.getLogger("chef").isDebugEnabled()) {
                Log.debug("chef", "ASSIGNMENT : BASE SERVICE : BASE CONTENT : TOXML : SAVED REGULAR PROPERTIES");
            }
            stack.pop();
            Xml.encodeAttribute(content, "instructions", this.m_instructions);
            return content;
        }

        protected void setAll(AssignmentContent content) {
            if (content != null) {
                this.m_id = content.getId();
                this.m_context = content.getContext();
                this.m_authors = content.getAuthors();
                this.m_attachments = content.getAttachments();
                this.m_title = content.getTitle();
                this.m_instructions = content.getInstructions();
                this.m_honorPledge = content.getHonorPledge();
                this.m_typeOfSubmission = content.getTypeOfSubmission();
                this.m_typeOfGrade = content.getTypeOfGrade();
                this.m_maxGradePoint = content.getMaxGradePoint();
                this.m_groupProject = content.getGroupProject();
                this.m_individuallyGraded = content.individuallyGraded();
                this.m_releaseGrades = content.releaseGrades();
                this.m_allowAttachments = content.getAllowAttachments();
                this.m_timeCreated = content.getTimeCreated();
                this.m_timeLastModified = content.getTimeLastModified();
                this.m_properties = new BaseResourcePropertiesEdit();
                this.m_properties.addAll(content.getProperties());
            }
        }

        public String getId() {
            return this.m_id;
        }

        public String getUrl() {
            return BaseAssignmentService.this.getAccessPoint(false) + "/" + "c" + "/" + this.m_context + "/" + this.m_id;
        }

        public String getReference() {
            return BaseAssignmentService.this.contentReference(this.m_context, this.m_id);
        }

        public ResourceProperties getProperties() {
            return this.m_properties;
        }

        public ReferenceVector getAttachments() {
            return this.m_attachments;
        }

        public String getContext() {
            return this.m_context;
        }

        public FlexStringArray getAuthors() {
            return this.m_authors;
        }

        public String getCreator() {
            return this.m_properties.getProperty("CHEF:creator");
        }

        public String getAuthorLastModified() {
            return this.m_properties.getProperty("CHEF:modifiedby");
        }

        public String getTitle() {
            return this.m_title;
        }

        public String getInstructions() {
            return this.m_instructions;
        }

        public int getTypeOfSubmission() {
            return this.m_typeOfSubmission;
        }

        public String getTypeOfGradeString(int type) {
            String retVal = null;
            switch (type) {
                case 1: {
                    retVal = "Ungraded";
                    break;
                }
                case 2: {
                    retVal = "Letter Grade";
                    break;
                }
                case 3: {
                    retVal = "Score Grade";
                    break;
                }
                case 4: {
                    retVal = "Pass / Fail Grade";
                    break;
                }
                case 5: {
                    retVal = "Check Grade";
                    break;
                }
                default: {
                    retVal = "Unknown Grade Type";
                }
            }
            return retVal;
        }

        public int getTypeOfGrade() {
            return this.m_typeOfGrade;
        }

        public int getMaxGradePoint() {
            return this.m_maxGradePoint;
        }

        public boolean getGroupProject() {
            return this.m_groupProject;
        }

        public boolean individuallyGraded() {
            return this.m_individuallyGraded;
        }

        public boolean releaseGrades() {
            return this.m_releaseGrades;
        }

        public int getHonorPledge() {
            return this.m_honorPledge;
        }

        public boolean getAllowAttachments() {
            return this.m_allowAttachments;
        }

        public Time getTimeCreated() {
            return this.m_timeCreated;
        }

        public Time getTimeLastModified() {
            return this.m_timeLastModified;
        }

        public boolean inUse() {
            boolean retVal = false;
            Assignment assignment = null;
            List allAssignments = BaseAssignmentService.this.getAssignments();
            int x = 0;
            while (x < allAssignments.size()) {
                assignment = (Assignment)allAssignments.get(x);
                if (assignment.getContentReference().equals(this.getReference())) {
                    return true;
                }
                ++x;
            }
            return retVal;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof AssignmentContent)) {
                return false;
            }
            return ((AssignmentContent)obj).getId().equals(this.getId());
        }

        public int compareTo(Object obj) {
            if (!(obj instanceof AssignmentContent)) {
                throw new ClassCastException();
            }
            if (obj == this) {
                return 0;
            }
            int compare = this.getTitle().compareTo(((AssignmentContent)obj).getTitle());
            if (compare == 0) {
                compare = this.getId().compareTo(((AssignmentContent)obj).getId());
            }
            return compare;
        }
    }

    public class BaseAssignmentEdit
    extends BaseAssignment
    implements AssignmentEdit,
    SessionStateBindingListener {
        protected String m_event = null;
        protected boolean m_active = false;

        public BaseAssignmentEdit(Assignment assignment) {
            super(assignment);
        }

        public BaseAssignmentEdit(String id, String context) {
            super(id, context);
        }

        public BaseAssignmentEdit(Element el) {
            super(el);
        }

        protected void finalize() {
            if (this.m_active) {
                BaseAssignmentService.this.cancelEdit(this);
            }
        }

        public void setTitle(String title) {
            this.m_title = title;
        }

        public void setContentReference(String contentReference) {
            if (contentReference != null) {
                this.m_assignmentContent = contentReference;
            }
        }

        public void setContent(AssignmentContent content) {
            if (content != null) {
                this.m_assignmentContent = content.getReference();
            }
        }

        public void setContext(String context) {
            this.m_context = context;
        }

        public void setSection(String sectionId) {
            this.m_section = sectionId;
        }

        public void setTimeLastModified(Time lastmod) {
            if (lastmod != null) {
                this.m_timeLastModified = lastmod;
            }
        }

        public void setOpenTime(Time opentime) {
            this.m_openTime = opentime;
        }

        public void setDueTime(Time duetime) {
            this.m_dueTime = duetime;
        }

        public void setDropDeadTime(Time dropdeadtime) {
            this.m_dropDeadTime = dropdeadtime;
        }

        public void setCloseTime(Time closetime) {
            this.m_closeTime = closetime;
        }

        public void setDraft(boolean draft) {
            this.m_draft = draft;
        }

        protected void set(Assignment assignment) {
            this.setAll(assignment);
        }

        protected String getEvent() {
            return this.m_event;
        }

        protected void setEvent(String event) {
            this.m_event = event;
        }

        public ResourcePropertiesEdit getPropertiesEdit() {
            return this.m_properties;
        }

        protected void activate() {
            this.m_active = true;
        }

        public boolean isActiveEdit() {
            return this.m_active;
        }

        protected void closeEdit() {
            this.m_active = false;
        }

        public void valueBound(String sessionStateKey, String attributeName) {
        }

        public void valueUnbound(String sessionStateKey, String attributeName) {
            if (Log.getLogger("chef").isDebugEnabled()) {
                Log.debug("chef", this + ".valueUnbound()");
            }
            if (this.m_active) {
                BaseAssignmentService.this.cancelEdit(this);
            }
        }
    }

    public class BaseAssignment
    implements Assignment {
        protected ResourcePropertiesEdit m_properties;
        protected String m_id;
        protected String m_assignmentContent;
        protected String m_title;
        protected String m_context;
        protected String m_section;
        protected Time m_openTime;
        protected Time m_dueTime;
        protected Time m_closeTime;
        protected Time m_dropDeadTime;
        protected Time m_timeCreated;
        protected Time m_timeLastModified;
        protected FlexStringArray m_authors;
        protected boolean m_draft;

        public BaseAssignment(Assignment assignment) {
            this.setAll(assignment);
        }

        public BaseAssignment(String id, String context) {
            this.m_properties = new BaseResourcePropertiesEdit();
            BaseAssignmentService.this.addLiveProperties(this.m_properties);
            this.m_id = id;
            this.m_assignmentContent = "";
            this.m_title = "";
            this.m_context = context;
            this.m_section = "";
            this.m_authors = new FlexStringArray();
            this.m_draft = true;
            this.m_timeCreated = new Time();
            this.m_timeLastModified = new Time();
        }

        public BaseAssignment(Element el) {
            if (Log.getLogger("chef").isDebugEnabled()) {
                Log.debug("chef", "ASSIGNMENT : BASE SERVICE : BASE ASSIGNMENT : ENTERING STORAGE CONSTRUCTOR");
            }
            this.m_properties = new BaseResourcePropertiesEdit();
            int numAttributes = 0;
            Object bool = null;
            String intString = null;
            String attributeString = null;
            String tempString = null;
            Object tempReference = null;
            Object tempContent = null;
            this.m_id = el.getAttribute("id");
            if (Log.getLogger("chef").isDebugEnabled()) {
                Log.debug("chef", "ASSIGNMENT : BASE SERVICE : BASE ASSIGNMENT : STORAGE CONSTRUCTOR : ASSIGNMENT ID : " + this.m_id);
            }
            this.m_title = el.getAttribute("title");
            this.m_section = el.getAttribute("section");
            this.m_draft = BaseAssignmentService.this.getBool(el.getAttribute("draft"));
            if (Log.getLogger("chef").isDebugEnabled()) {
                Log.debug("chef", "ASSIGNMENT : BASE SERVICE : BASE ASSIGNMENT : STORAGE CONSTRUCTOR : READ THROUGH REG ATTS");
            }
            this.m_assignmentContent = el.getAttribute("assignmentcontent");
            if (Log.getLogger("chef").isDebugEnabled()) {
                Log.debug("chef", "ASSIGNMENT : BASE SERVICE : BASE ASSIGNMENT : STORAGE CONSTRUCTOR : CONTENT ID : " + this.m_assignmentContent);
            }
            this.m_openTime = BaseAssignmentService.this.getTimeObject(el.getAttribute("opendate"));
            this.m_dueTime = BaseAssignmentService.this.getTimeObject(el.getAttribute("duedate"));
            this.m_dropDeadTime = BaseAssignmentService.this.getTimeObject(el.getAttribute("dropdeaddate"));
            this.m_closeTime = BaseAssignmentService.this.getTimeObject(el.getAttribute("closedate"));
            this.m_timeCreated = BaseAssignmentService.this.getTimeObject(el.getAttribute("datecreated"));
            this.m_timeLastModified = BaseAssignmentService.this.getTimeObject(el.getAttribute("lastmod"));
            this.m_context = el.getAttribute("context");
            this.m_authors = new FlexStringArray();
            intString = el.getAttribute("numberofauthors");
            if (Log.getLogger("chef").isDebugEnabled()) {
                Log.debug("chef", "ASSIGNMENT : BASE SERVICE : BASE ASSIGNMENT : STORAGE CONSTRUCTOR : number of authors : " + intString);
            }
            try {
                numAttributes = Integer.parseInt(intString);
                int x = 0;
                while (x < numAttributes) {
                    if (Log.getLogger("chef").isDebugEnabled()) {
                        Log.debug("chef", "ASSIGNMENT : BASE SERVICE : BASE ASSIGNMENT : STORAGE CONSTRUCTOR : reading author # " + x);
                    }
                    if ((tempString = el.getAttribute(attributeString = "author" + x)) != null) {
                        if (Log.getLogger("chef").isDebugEnabled()) {
                            Log.debug("chef", "ASSIGNMENT : BASE SERVICE : BASE ASSIGNMENT : STORAGE CONSTRUCTOR : adding author # " + x + " id :  " + tempString);
                        }
                        this.m_authors.add(tempString);
                    }
                    ++x;
                }
            }
            catch (Exception e) {
                Log.warn("chef", "ASSIGNMENT : BASE SERVICE : BASE ASSIGNMENT : STORAGE CONSTRUCTOR : Exception reading authors : " + e);
            }
            NodeList children = el.getChildNodes();
            int length = children.getLength();
            int i = 0;
            while (i < length) {
                Element element;
                Node child = children.item(i);
                if (child.getNodeType() == 1 && (element = (Element)child).getTagName().equals("properties")) {
                    this.m_properties = new BaseResourcePropertiesEdit(element);
                }
                ++i;
            }
            if (Log.getLogger("chef").isDebugEnabled()) {
                Log.debug("chef", "ASSIGNMENT : BASE SERVICE : BASE ASSIGNMENT : LEAVING STORAGE CONSTRUCTOR");
            }
        }

        public Element toXml(Document doc, Stack stack) {
            if (Log.getLogger("chef").isDebugEnabled()) {
                Log.debug("chef", "ASSIGNMENT : BASE SERVICE : BASE ASSIGNMENT : ENTERING TOXML");
            }
            Element assignment = doc.createElement("assignment");
            if (stack.isEmpty()) {
                doc.appendChild(assignment);
            } else {
                ((Element)stack.peek()).appendChild(assignment);
            }
            stack.push(assignment);
            String numItemsString = null;
            String attributeString = null;
            String itemString = null;
            Object tempReference = null;
            assignment.setAttribute("id", this.m_id);
            assignment.setAttribute("title", this.m_title);
            assignment.setAttribute("section", this.m_section);
            assignment.setAttribute("context", this.m_context);
            assignment.setAttribute("assignmentcontent", this.m_assignmentContent);
            assignment.setAttribute("draft", BaseAssignmentService.this.getBoolString(this.m_draft));
            assignment.setAttribute("opendate", BaseAssignmentService.this.getTimeString(this.m_openTime));
            assignment.setAttribute("duedate", BaseAssignmentService.this.getTimeString(this.m_dueTime));
            assignment.setAttribute("dropdeaddate", BaseAssignmentService.this.getTimeString(this.m_dropDeadTime));
            assignment.setAttribute("closedate", BaseAssignmentService.this.getTimeString(this.m_closeTime));
            assignment.setAttribute("datecreated", BaseAssignmentService.this.getTimeString(this.m_timeCreated));
            assignment.setAttribute("lastmod", BaseAssignmentService.this.getTimeString(this.m_timeLastModified));
            if (Log.getLogger("chef").isDebugEnabled()) {
                Log.debug("chef", "ASSIGNMENT : BASE SERVICE : BASE ASSIGNMENT : TOXML : saved regular properties");
            }
            numItemsString = "" + this.m_authors.size();
            if (Log.getLogger("chef").isDebugEnabled()) {
                Log.debug("chef", "ASSIGNMENT : BASE SERVICE : BASE ASSIGNMENT : TOXML : saving " + numItemsString + " authors");
            }
            assignment.setAttribute("numberofauthors", numItemsString);
            int x = 0;
            while (x < this.m_authors.size()) {
                attributeString = "author" + x;
                itemString = this.m_authors.get(x);
                if (itemString != null) {
                    assignment.setAttribute(attributeString, itemString);
                    if (Log.getLogger("chef").isDebugEnabled()) {
                        Log.debug("chef", "ASSIGNMENT : BASE SERVICE : BASE ASSIGNMENT : TOXML : saving author : " + itemString);
                    }
                }
                ++x;
            }
            this.m_properties.toXml(doc, stack);
            Log.debug("chef", "ASSIGNMENT : BASE SERVICE : BASE ASSIGNMENT : TOXML : SAVED PROPERTIES");
            stack.pop();
            if (Log.getLogger("chef").isDebugEnabled()) {
                Log.debug("chef", "ASSIGNMENT : BASE ASSIGNMENT : LEAVING TOXML");
            }
            return assignment;
        }

        protected void setAll(Assignment assignment) {
            if (assignment != null) {
                this.m_id = assignment.getId();
                this.m_assignmentContent = assignment.getContentReference();
                this.m_authors = assignment.getAuthors();
                this.m_title = assignment.getTitle();
                this.m_context = assignment.getContext();
                this.m_section = assignment.getSection();
                this.m_openTime = assignment.getOpenTime();
                this.m_dueTime = assignment.getDueTime();
                this.m_closeTime = assignment.getCloseTime();
                this.m_dropDeadTime = assignment.getDropDeadTime();
                this.m_timeCreated = assignment.getTimeCreated();
                this.m_timeLastModified = assignment.getTimeLastModified();
                this.m_draft = assignment.getDraft();
                this.m_properties = new BaseResourcePropertiesEdit();
                this.m_properties.addAll(assignment.getProperties());
            }
        }

        public String getId() {
            return this.m_id;
        }

        public String getUrl() {
            return BaseAssignmentService.this.getAccessPoint(false) + "/" + "a" + "/" + this.m_context + "/" + this.m_id;
        }

        public String getReference() {
            return BaseAssignmentService.this.assignmentReference(this.m_context, this.m_id);
        }

        public ResourceProperties getProperties() {
            return this.m_properties;
        }

        public FlexStringArray getAuthors() {
            return this.m_authors;
        }

        public void addAuthor(User author) {
            if (author != null) {
                this.m_authors.add(author.getId());
            }
        }

        public void removeAuthor(User author) {
            if (author != null) {
                this.m_authors.remove(author.getId());
            }
        }

        public String getCreator() {
            return this.m_properties.getProperty("CHEF:creator");
        }

        public String getAuthorLastModified() {
            return this.m_properties.getProperty("CHEF:modifiedby");
        }

        public String getTitle() {
            return this.m_title;
        }

        public Time getTimeCreated() {
            return this.m_timeCreated;
        }

        public Time getTimeLastModified() {
            return this.m_timeLastModified;
        }

        public AssignmentContent getContent() {
            AssignmentContent retVal = null;
            if (this.m_assignmentContent != null) {
                try {
                    retVal = BaseAssignmentService.this.getAssignmentContent(this.m_assignmentContent);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return retVal;
        }

        public String getContentReference() {
            return this.m_assignmentContent;
        }

        public String getContext() {
            return this.m_context;
        }

        public String getSection() {
            return this.m_section;
        }

        public Time getOpenTime() {
            return this.m_openTime;
        }

        public Time getDueTime() {
            return this.m_dueTime;
        }

        public Time getDropDeadTime() {
            return this.m_dropDeadTime;
        }

        public Time getCloseTime() {
            return this.m_closeTime;
        }

        public boolean getDraft() {
            return this.m_draft;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Assignment)) {
                return false;
            }
            return ((Assignment)obj).getId().equals(this.getId());
        }

        public int compareTo(Object obj) {
            if (!(obj instanceof Assignment)) {
                throw new ClassCastException();
            }
            if (obj == this) {
                return 0;
            }
            int compare = this.getTitle().compareTo(((Assignment)obj).getTitle());
            if (compare == 0) {
                compare = this.getId().compareTo(((Assignment)obj).getId());
            }
            return compare;
        }
    }
}

