# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class ComplianceState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The compliance state that should be set on the resource."""

    COMPLIANT = "Compliant"
    """The resource is in compliance with the policy."""
    NON_COMPLIANT = "NonCompliant"
    """The resource is not in compliance with the policy."""
    UNKNOWN = "Unknown"
    """The compliance state of the resource is not known."""


class ComponentPolicyStatesResource(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """ComponentPolicyStatesResource."""

    LATEST = "latest"


class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of identity that created the resource."""

    USER = "User"
    APPLICATION = "Application"
    MANAGED_IDENTITY = "ManagedIdentity"
    KEY = "Key"


class FieldRestrictionResult(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of restriction that is imposed on the field."""

    REQUIRED = "Required"
    """The field and/or values are required by policy."""
    REMOVED = "Removed"
    """The field will be removed by policy."""
    DENY = "Deny"
    """The field and/or values will be denied by policy."""
    AUDIT = "Audit"
    """The field and/or values will be audited by policy."""


class PolicyEventsResourceType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """PolicyEventsResourceType."""

    DEFAULT = "default"


class PolicyStatesResource(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """PolicyStatesResource."""

    DEFAULT = "default"
    LATEST = "latest"


class PolicyStatesSummaryResourceType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """PolicyStatesSummaryResourceType."""

    LATEST = "latest"


class PolicyTrackedResourcesResourceType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """PolicyTrackedResourcesResourceType."""

    DEFAULT = "default"


class ResourceDiscoveryMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The way resources to remediate are discovered. Defaults to ExistingNonCompliant if not
    specified.
    """

    EXISTING_NON_COMPLIANT = "ExistingNonCompliant"
    """Remediate resources that are already known to be non-compliant."""
    RE_EVALUATE_COMPLIANCE = "ReEvaluateCompliance"
    """Re-evaluate the compliance state of resources and then remediate the resources found to be
    non-compliant. The resourceIds filter cannot be used in this mode."""
