/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.smiles;

import org.jmol.smiles.SmilesBond;
import org.jmol.smiles.SmilesMolecule;

public class SmilesAtom {
    private int number;
    private String symbol;
    private int atomicMass;
    private int charge;
    private int hydrogenCount;
    private int matchingAtom;
    private String chiralClass;
    private int chiralOrder;
    private SmilesBond[] bonds;
    private int bondsCount;
    private static final int INITIAL_BONDS = 4;
    public static final String DEFAULT_CHIRALITY = "";
    public static final String CHIRALITY_ALLENE = "AL";
    public static final String CHIRALITY_OCTAHEDRAL = "OH";
    public static final String CHIRALITY_SQUARE_PLANAR = "SP";
    public static final String CHIRALITY_TETRAHEDRAL = "TH";
    public static final String CHIRALITY_TRIGONAL_BIPYRAMIDAL = "TB";

    public SmilesAtom(int n) {
        this.number = n;
        this.symbol = null;
        this.atomicMass = Integer.MIN_VALUE;
        this.charge = 0;
        this.hydrogenCount = Integer.MIN_VALUE;
        this.matchingAtom = -1;
        this.chiralClass = null;
        this.chiralOrder = Integer.MIN_VALUE;
        this.bonds = new SmilesBond[4];
        this.bondsCount = 0;
    }

    public void createMissingHydrogen(SmilesMolecule smilesMolecule) {
        Object object;
        int n;
        int n2 = 0;
        if (this.hydrogenCount == Integer.MIN_VALUE) {
            if (this.symbol != null) {
                if (this.symbol == "B") {
                    n2 = 3;
                } else if (this.symbol == "Br") {
                    n2 = 1;
                } else if (this.symbol == "C") {
                    n2 = 4;
                } else if (this.symbol == "Cl") {
                    n2 = 1;
                } else if (this.symbol == "F") {
                    n2 = 1;
                } else if (this.symbol == "I") {
                    n2 = 1;
                } else if (this.symbol == "N") {
                    n2 = 3;
                } else if (this.symbol == "O") {
                    n2 = 2;
                } else if (this.symbol == "P") {
                    n2 = 3;
                } else if (this.symbol == "S") {
                    n2 = 2;
                }
            }
            block5: for (n = 0; n < this.bondsCount; ++n) {
                object = this.bonds[n];
                switch (((SmilesBond)object).getBondType()) {
                    case 1: 
                    case 5: 
                    case 6: {
                        --n2;
                        continue block5;
                    }
                    case 2: {
                        n2 -= 2;
                        continue block5;
                    }
                    case 3: {
                        n2 -= 3;
                    }
                }
            }
        } else {
            n2 = this.hydrogenCount;
        }
        for (n = 0; n < n2; ++n) {
            object = smilesMolecule.createAtom();
            smilesMolecule.createBond(this, (SmilesAtom)object, 1);
            ((SmilesAtom)object).setSymbol("H");
        }
    }

    public int getNumber() {
        return this.number;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public void setSymbol(String string) {
        this.symbol = string != null ? string.intern() : null;
    }

    public int getAtomicMass() {
        return this.atomicMass;
    }

    public void setAtomicMass(int n) {
        this.atomicMass = n;
    }

    public int getCharge() {
        return this.charge;
    }

    public void setCharge(int n) {
        this.charge = n;
    }

    public int getMatchingAtom() {
        return this.matchingAtom;
    }

    public void setMatchingAtom(int n) {
        this.matchingAtom = n;
    }

    public String getChiralClass() {
        return this.chiralClass;
    }

    public void setChiralClass(String string) {
        this.chiralClass = string != null ? string.intern() : null;
    }

    public int getChiralOrder() {
        return this.chiralOrder;
    }

    public void setChiralOrder(int n) {
        this.chiralOrder = n;
    }

    public int getHydrogenCount() {
        return this.hydrogenCount;
    }

    public void setHydrogenCount(int n) {
        this.hydrogenCount = n;
    }

    public int getBondsCount() {
        return this.bondsCount;
    }

    public SmilesBond getBond(int n) {
        if (n >= 0 && n < this.bondsCount) {
            return this.bonds[n];
        }
        return null;
    }

    public void addBond(SmilesBond smilesBond) {
        if (this.bondsCount >= this.bonds.length) {
            SmilesBond[] smilesBondArray = new SmilesBond[this.bonds.length * 2];
            System.arraycopy(this.bonds, 0, smilesBondArray, 0, this.bonds.length);
            this.bonds = smilesBondArray;
        }
        this.bonds[this.bondsCount] = smilesBond;
        ++this.bondsCount;
    }
}

