// Take a look at the license at the top of the repository in the LICENSE file.

use glib::{Variant, translate::*};

use crate::{Actionable, prelude::*};

// rustdoc-stripper-ignore-next
/// Trait containing manually implemented methods of
/// [`Actionable`](crate::Actionable).
pub trait ActionableExtManual: IsA<Actionable> + 'static {
    #[doc(alias = "gtk_actionable_set_action_target")]
    #[doc(alias = "gtk_actionable_set_action_target_value")]
    fn set_action_target(&self, target: Option<impl Into<Variant>>) {
        unsafe {
            crate::ffi::gtk_actionable_set_action_target_value(
                self.as_ref().to_glib_none().0,
                target.map(|v| v.into()).to_glib_none().0,
            );
        }
    }
}

impl<O: IsA<Actionable>> ActionableExtManual for O {}
