// GENERATED FILE - DO NOT EDIT.
// Generated by generate_entry_points.py using data from gl.xml and gl_angle_ext.xml.
//
// Copyright 2020 The ANGLE Project Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//
// capture_gles_1_0_autogen.cpp:
//   Capture functions for the OpenGL ES 1.0 entry points.

#include "libANGLE/capture/capture_gles_1_0_autogen.h"

#include "common/gl_enum_utils.h"
#include "libANGLE/Context.h"
#include "libANGLE/capture/FrameCapture.h"
#include "libANGLE/validationES1.h"

using namespace angle;

namespace gl
{
CallCapture CaptureAlphaFunc(const State &glState,
                             bool isCallValid,
                             AlphaTestFunc funcPacked,
                             GLfloat ref)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("funcPacked", ParamType::TAlphaTestFunc, funcPacked);
    paramBuffer.addValueParam("ref", ParamType::TGLfloat, ref);

    return CallCapture(angle::EntryPoint::GLAlphaFunc, std::move(paramBuffer));
}

CallCapture CaptureAlphaFuncx(const State &glState,
                              bool isCallValid,
                              AlphaTestFunc funcPacked,
                              GLfixed ref)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("funcPacked", ParamType::TAlphaTestFunc, funcPacked);
    paramBuffer.addValueParam("ref", ParamType::TGLfixed, ref);

    return CallCapture(angle::EntryPoint::GLAlphaFuncx, std::move(paramBuffer));
}

CallCapture CaptureClearColorx(const State &glState,
                               bool isCallValid,
                               GLfixed red,
                               GLfixed green,
                               GLfixed blue,
                               GLfixed alpha)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("red", ParamType::TGLfixed, red);
    paramBuffer.addValueParam("green", ParamType::TGLfixed, green);
    paramBuffer.addValueParam("blue", ParamType::TGLfixed, blue);
    paramBuffer.addValueParam("alpha", ParamType::TGLfixed, alpha);

    return CallCapture(angle::EntryPoint::GLClearColorx, std::move(paramBuffer));
}

CallCapture CaptureClearDepthx(const State &glState, bool isCallValid, GLfixed depth)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("depth", ParamType::TGLfixed, depth);

    return CallCapture(angle::EntryPoint::GLClearDepthx, std::move(paramBuffer));
}

CallCapture CaptureClientActiveTexture(const State &glState, bool isCallValid, GLenum texture)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("texture", GLESEnum::TextureUnit, ParamType::TGLenum, texture);

    return CallCapture(angle::EntryPoint::GLClientActiveTexture, std::move(paramBuffer));
}

CallCapture CaptureClipPlanef(const State &glState, bool isCallValid, GLenum p, const GLfloat *eqn)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("p", GLESEnum::ClipPlaneName, ParamType::TGLenum, p);

    if (isCallValid)
    {
        ParamCapture eqnParam("eqn", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, eqn, &eqnParam.value);
        CaptureClipPlanef_eqn(glState, isCallValid, p, eqn, &eqnParam);
        paramBuffer.addParam(std::move(eqnParam));
    }
    else
    {
        ParamCapture eqnParam("eqn", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, static_cast<const GLfloat *>(nullptr),
                       &eqnParam.value);
        paramBuffer.addParam(std::move(eqnParam));
    }

    return CallCapture(angle::EntryPoint::GLClipPlanef, std::move(paramBuffer));
}

CallCapture CaptureClipPlanex(const State &glState,
                              bool isCallValid,
                              GLenum plane,
                              const GLfixed *equation)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("plane", GLESEnum::ClipPlaneName, ParamType::TGLenum, plane);

    if (isCallValid)
    {
        ParamCapture equationParam("equation", ParamType::TGLfixedConstPointer);
        InitParamValue(ParamType::TGLfixedConstPointer, equation, &equationParam.value);
        CaptureClipPlanex_equation(glState, isCallValid, plane, equation, &equationParam);
        paramBuffer.addParam(std::move(equationParam));
    }
    else
    {
        ParamCapture equationParam("equation", ParamType::TGLfixedConstPointer);
        InitParamValue(ParamType::TGLfixedConstPointer, static_cast<const GLfixed *>(nullptr),
                       &equationParam.value);
        paramBuffer.addParam(std::move(equationParam));
    }

    return CallCapture(angle::EntryPoint::GLClipPlanex, std::move(paramBuffer));
}

CallCapture CaptureColor4f(const State &glState,
                           bool isCallValid,
                           GLfloat red,
                           GLfloat green,
                           GLfloat blue,
                           GLfloat alpha)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("red", ParamType::TGLfloat, red);
    paramBuffer.addValueParam("green", ParamType::TGLfloat, green);
    paramBuffer.addValueParam("blue", ParamType::TGLfloat, blue);
    paramBuffer.addValueParam("alpha", ParamType::TGLfloat, alpha);

    return CallCapture(angle::EntryPoint::GLColor4f, std::move(paramBuffer));
}

CallCapture CaptureColor4ub(const State &glState,
                            bool isCallValid,
                            GLubyte red,
                            GLubyte green,
                            GLubyte blue,
                            GLubyte alpha)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("red", ParamType::TGLubyte, red);
    paramBuffer.addValueParam("green", ParamType::TGLubyte, green);
    paramBuffer.addValueParam("blue", ParamType::TGLubyte, blue);
    paramBuffer.addValueParam("alpha", ParamType::TGLubyte, alpha);

    return CallCapture(angle::EntryPoint::GLColor4ub, std::move(paramBuffer));
}

CallCapture CaptureColor4x(const State &glState,
                           bool isCallValid,
                           GLfixed red,
                           GLfixed green,
                           GLfixed blue,
                           GLfixed alpha)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("red", ParamType::TGLfixed, red);
    paramBuffer.addValueParam("green", ParamType::TGLfixed, green);
    paramBuffer.addValueParam("blue", ParamType::TGLfixed, blue);
    paramBuffer.addValueParam("alpha", ParamType::TGLfixed, alpha);

    return CallCapture(angle::EntryPoint::GLColor4x, std::move(paramBuffer));
}

CallCapture CaptureColorPointer(const State &glState,
                                bool isCallValid,
                                GLint size,
                                VertexAttribType typePacked,
                                GLsizei stride,
                                const void *pointer)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("size", ParamType::TGLint, size);
    paramBuffer.addValueParam("typePacked", ParamType::TVertexAttribType, typePacked);
    paramBuffer.addValueParam("stride", ParamType::TGLsizei, stride);

    if (isCallValid)
    {
        ParamCapture pointerParam("pointer", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, pointer, &pointerParam.value);
        CaptureColorPointer_pointer(glState, isCallValid, size, typePacked, stride, pointer,
                                    &pointerParam);
        paramBuffer.addParam(std::move(pointerParam));
    }
    else
    {
        ParamCapture pointerParam("pointer", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &pointerParam.value);
        paramBuffer.addParam(std::move(pointerParam));
    }

    return CallCapture(angle::EntryPoint::GLColorPointer, std::move(paramBuffer));
}

CallCapture CaptureDepthRangex(const State &glState, bool isCallValid, GLfixed n, GLfixed f)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("n", ParamType::TGLfixed, n);
    paramBuffer.addValueParam("f", ParamType::TGLfixed, f);

    return CallCapture(angle::EntryPoint::GLDepthRangex, std::move(paramBuffer));
}

CallCapture CaptureDisableClientState(const State &glState,
                                      bool isCallValid,
                                      ClientVertexArrayType arrayPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("arrayPacked", ParamType::TClientVertexArrayType, arrayPacked);

    return CallCapture(angle::EntryPoint::GLDisableClientState, std::move(paramBuffer));
}

CallCapture CaptureEnableClientState(const State &glState,
                                     bool isCallValid,
                                     ClientVertexArrayType arrayPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("arrayPacked", ParamType::TClientVertexArrayType, arrayPacked);

    return CallCapture(angle::EntryPoint::GLEnableClientState, std::move(paramBuffer));
}

CallCapture CaptureFogf(const State &glState, bool isCallValid, GLenum pname, GLfloat param)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("pname", GLESEnum::FogParameter, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("param", ParamType::TGLfloat, param);

    return CallCapture(angle::EntryPoint::GLFogf, std::move(paramBuffer));
}

CallCapture CaptureFogfv(const State &glState,
                         bool isCallValid,
                         GLenum pname,
                         const GLfloat *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("pname", GLESEnum::FogParameter, ParamType::TGLenum, pname);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, params, &paramsParam.value);
        CaptureFogfv_params(glState, isCallValid, pname, params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, static_cast<const GLfloat *>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLFogfv, std::move(paramBuffer));
}

CallCapture CaptureFogx(const State &glState, bool isCallValid, GLenum pname, GLfixed param)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("pname", GLESEnum::FogPName, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("param", ParamType::TGLfixed, param);

    return CallCapture(angle::EntryPoint::GLFogx, std::move(paramBuffer));
}

CallCapture CaptureFogxv(const State &glState, bool isCallValid, GLenum pname, const GLfixed *param)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("pname", GLESEnum::FogPName, ParamType::TGLenum, pname);

    if (isCallValid)
    {
        ParamCapture paramParam("param", ParamType::TGLfixedConstPointer);
        InitParamValue(ParamType::TGLfixedConstPointer, param, &paramParam.value);
        CaptureFogxv_param(glState, isCallValid, pname, param, &paramParam);
        paramBuffer.addParam(std::move(paramParam));
    }
    else
    {
        ParamCapture paramParam("param", ParamType::TGLfixedConstPointer);
        InitParamValue(ParamType::TGLfixedConstPointer, static_cast<const GLfixed *>(nullptr),
                       &paramParam.value);
        paramBuffer.addParam(std::move(paramParam));
    }

    return CallCapture(angle::EntryPoint::GLFogxv, std::move(paramBuffer));
}

CallCapture CaptureFrustumf(const State &glState,
                            bool isCallValid,
                            GLfloat l,
                            GLfloat r,
                            GLfloat b,
                            GLfloat t,
                            GLfloat n,
                            GLfloat f)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("l", ParamType::TGLfloat, l);
    paramBuffer.addValueParam("r", ParamType::TGLfloat, r);
    paramBuffer.addValueParam("b", ParamType::TGLfloat, b);
    paramBuffer.addValueParam("t", ParamType::TGLfloat, t);
    paramBuffer.addValueParam("n", ParamType::TGLfloat, n);
    paramBuffer.addValueParam("f", ParamType::TGLfloat, f);

    return CallCapture(angle::EntryPoint::GLFrustumf, std::move(paramBuffer));
}

CallCapture CaptureFrustumx(const State &glState,
                            bool isCallValid,
                            GLfixed l,
                            GLfixed r,
                            GLfixed b,
                            GLfixed t,
                            GLfixed n,
                            GLfixed f)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("l", ParamType::TGLfixed, l);
    paramBuffer.addValueParam("r", ParamType::TGLfixed, r);
    paramBuffer.addValueParam("b", ParamType::TGLfixed, b);
    paramBuffer.addValueParam("t", ParamType::TGLfixed, t);
    paramBuffer.addValueParam("n", ParamType::TGLfixed, n);
    paramBuffer.addValueParam("f", ParamType::TGLfixed, f);

    return CallCapture(angle::EntryPoint::GLFrustumx, std::move(paramBuffer));
}

CallCapture CaptureGetClipPlanef(const State &glState,
                                 bool isCallValid,
                                 GLenum plane,
                                 GLfloat *equation)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("plane", GLESEnum::ClipPlaneName, ParamType::TGLenum, plane);

    if (isCallValid)
    {
        ParamCapture equationParam("equation", ParamType::TGLfloatPointer);
        InitParamValue(ParamType::TGLfloatPointer, equation, &equationParam.value);
        CaptureGetClipPlanef_equation(glState, isCallValid, plane, equation, &equationParam);
        paramBuffer.addParam(std::move(equationParam));
    }
    else
    {
        ParamCapture equationParam("equation", ParamType::TGLfloatPointer);
        InitParamValue(ParamType::TGLfloatPointer, static_cast<GLfloat *>(nullptr),
                       &equationParam.value);
        paramBuffer.addParam(std::move(equationParam));
    }

    return CallCapture(angle::EntryPoint::GLGetClipPlanef, std::move(paramBuffer));
}

CallCapture CaptureGetClipPlanex(const State &glState,
                                 bool isCallValid,
                                 GLenum plane,
                                 GLfixed *equation)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("plane", GLESEnum::ClipPlaneName, ParamType::TGLenum, plane);

    if (isCallValid)
    {
        ParamCapture equationParam("equation", ParamType::TGLfixedPointer);
        InitParamValue(ParamType::TGLfixedPointer, equation, &equationParam.value);
        CaptureGetClipPlanex_equation(glState, isCallValid, plane, equation, &equationParam);
        paramBuffer.addParam(std::move(equationParam));
    }
    else
    {
        ParamCapture equationParam("equation", ParamType::TGLfixedPointer);
        InitParamValue(ParamType::TGLfixedPointer, static_cast<GLfixed *>(nullptr),
                       &equationParam.value);
        paramBuffer.addParam(std::move(equationParam));
    }

    return CallCapture(angle::EntryPoint::GLGetClipPlanex, std::move(paramBuffer));
}

CallCapture CaptureGetFixedv(const State &glState, bool isCallValid, GLenum pname, GLfixed *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("pname", GLESEnum::GetPName, ParamType::TGLenum, pname);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLfixedPointer);
        InitParamValue(ParamType::TGLfixedPointer, params, &paramsParam.value);
        CaptureGetFixedv_params(glState, isCallValid, pname, params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLfixedPointer);
        InitParamValue(ParamType::TGLfixedPointer, static_cast<GLfixed *>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetFixedv, std::move(paramBuffer));
}

CallCapture CaptureGetLightfv(const State &glState,
                              bool isCallValid,
                              GLenum light,
                              LightParameter pnamePacked,
                              GLfloat *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("light", GLESEnum::LightName, ParamType::TGLenum, light);
    paramBuffer.addValueParam("pnamePacked", ParamType::TLightParameter, pnamePacked);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLfloatPointer);
        InitParamValue(ParamType::TGLfloatPointer, params, &paramsParam.value);
        CaptureGetLightfv_params(glState, isCallValid, light, pnamePacked, params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLfloatPointer);
        InitParamValue(ParamType::TGLfloatPointer, static_cast<GLfloat *>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetLightfv, std::move(paramBuffer));
}

CallCapture CaptureGetLightxv(const State &glState,
                              bool isCallValid,
                              GLenum light,
                              LightParameter pnamePacked,
                              GLfixed *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("light", GLESEnum::LightName, ParamType::TGLenum, light);
    paramBuffer.addValueParam("pnamePacked", ParamType::TLightParameter, pnamePacked);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLfixedPointer);
        InitParamValue(ParamType::TGLfixedPointer, params, &paramsParam.value);
        CaptureGetLightxv_params(glState, isCallValid, light, pnamePacked, params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLfixedPointer);
        InitParamValue(ParamType::TGLfixedPointer, static_cast<GLfixed *>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetLightxv, std::move(paramBuffer));
}

CallCapture CaptureGetMaterialfv(const State &glState,
                                 bool isCallValid,
                                 GLenum face,
                                 MaterialParameter pnamePacked,
                                 GLfloat *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("face", GLESEnum::TriangleFace, ParamType::TGLenum, face);
    paramBuffer.addValueParam("pnamePacked", ParamType::TMaterialParameter, pnamePacked);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLfloatPointer);
        InitParamValue(ParamType::TGLfloatPointer, params, &paramsParam.value);
        CaptureGetMaterialfv_params(glState, isCallValid, face, pnamePacked, params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLfloatPointer);
        InitParamValue(ParamType::TGLfloatPointer, static_cast<GLfloat *>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetMaterialfv, std::move(paramBuffer));
}

CallCapture CaptureGetMaterialxv(const State &glState,
                                 bool isCallValid,
                                 GLenum face,
                                 MaterialParameter pnamePacked,
                                 GLfixed *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("face", GLESEnum::TriangleFace, ParamType::TGLenum, face);
    paramBuffer.addValueParam("pnamePacked", ParamType::TMaterialParameter, pnamePacked);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLfixedPointer);
        InitParamValue(ParamType::TGLfixedPointer, params, &paramsParam.value);
        CaptureGetMaterialxv_params(glState, isCallValid, face, pnamePacked, params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLfixedPointer);
        InitParamValue(ParamType::TGLfixedPointer, static_cast<GLfixed *>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetMaterialxv, std::move(paramBuffer));
}

CallCapture CaptureGetTexEnvfv(const State &glState,
                               bool isCallValid,
                               TextureEnvTarget targetPacked,
                               TextureEnvParameter pnamePacked,
                               GLfloat *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureEnvTarget, targetPacked);
    paramBuffer.addValueParam("pnamePacked", ParamType::TTextureEnvParameter, pnamePacked);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLfloatPointer);
        InitParamValue(ParamType::TGLfloatPointer, params, &paramsParam.value);
        CaptureGetTexEnvfv_params(glState, isCallValid, targetPacked, pnamePacked, params,
                                  &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLfloatPointer);
        InitParamValue(ParamType::TGLfloatPointer, static_cast<GLfloat *>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetTexEnvfv, std::move(paramBuffer));
}

CallCapture CaptureGetTexEnviv(const State &glState,
                               bool isCallValid,
                               TextureEnvTarget targetPacked,
                               TextureEnvParameter pnamePacked,
                               GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureEnvTarget, targetPacked);
    paramBuffer.addValueParam("pnamePacked", ParamType::TTextureEnvParameter, pnamePacked);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
        CaptureGetTexEnviv_params(glState, isCallValid, targetPacked, pnamePacked, params,
                                  &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr), &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetTexEnviv, std::move(paramBuffer));
}

CallCapture CaptureGetTexEnvxv(const State &glState,
                               bool isCallValid,
                               TextureEnvTarget targetPacked,
                               TextureEnvParameter pnamePacked,
                               GLfixed *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureEnvTarget, targetPacked);
    paramBuffer.addValueParam("pnamePacked", ParamType::TTextureEnvParameter, pnamePacked);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLfixedPointer);
        InitParamValue(ParamType::TGLfixedPointer, params, &paramsParam.value);
        CaptureGetTexEnvxv_params(glState, isCallValid, targetPacked, pnamePacked, params,
                                  &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLfixedPointer);
        InitParamValue(ParamType::TGLfixedPointer, static_cast<GLfixed *>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetTexEnvxv, std::move(paramBuffer));
}

CallCapture CaptureGetTexParameterxv(const State &glState,
                                     bool isCallValid,
                                     TextureType targetPacked,
                                     GLenum pname,
                                     GLfixed *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addEnumParam("pname", GLESEnum::GetTextureParameter, ParamType::TGLenum, pname);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLfixedPointer);
        InitParamValue(ParamType::TGLfixedPointer, params, &paramsParam.value);
        CaptureGetTexParameterxv_params(glState, isCallValid, targetPacked, pname, params,
                                        &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLfixedPointer);
        InitParamValue(ParamType::TGLfixedPointer, static_cast<GLfixed *>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetTexParameterxv, std::move(paramBuffer));
}

CallCapture CaptureLightModelf(const State &glState, bool isCallValid, GLenum pname, GLfloat param)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("pname", GLESEnum::LightModelParameter, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("param", ParamType::TGLfloat, param);

    return CallCapture(angle::EntryPoint::GLLightModelf, std::move(paramBuffer));
}

CallCapture CaptureLightModelfv(const State &glState,
                                bool isCallValid,
                                GLenum pname,
                                const GLfloat *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("pname", GLESEnum::LightModelParameter, ParamType::TGLenum, pname);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, params, &paramsParam.value);
        CaptureLightModelfv_params(glState, isCallValid, pname, params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, static_cast<const GLfloat *>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLLightModelfv, std::move(paramBuffer));
}

CallCapture CaptureLightModelx(const State &glState, bool isCallValid, GLenum pname, GLfixed param)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("pname", GLESEnum::LightModelParameter, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("param", ParamType::TGLfixed, param);

    return CallCapture(angle::EntryPoint::GLLightModelx, std::move(paramBuffer));
}

CallCapture CaptureLightModelxv(const State &glState,
                                bool isCallValid,
                                GLenum pname,
                                const GLfixed *param)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("pname", GLESEnum::LightModelParameter, ParamType::TGLenum, pname);

    if (isCallValid)
    {
        ParamCapture paramParam("param", ParamType::TGLfixedConstPointer);
        InitParamValue(ParamType::TGLfixedConstPointer, param, &paramParam.value);
        CaptureLightModelxv_param(glState, isCallValid, pname, param, &paramParam);
        paramBuffer.addParam(std::move(paramParam));
    }
    else
    {
        ParamCapture paramParam("param", ParamType::TGLfixedConstPointer);
        InitParamValue(ParamType::TGLfixedConstPointer, static_cast<const GLfixed *>(nullptr),
                       &paramParam.value);
        paramBuffer.addParam(std::move(paramParam));
    }

    return CallCapture(angle::EntryPoint::GLLightModelxv, std::move(paramBuffer));
}

CallCapture CaptureLightf(const State &glState,
                          bool isCallValid,
                          GLenum light,
                          LightParameter pnamePacked,
                          GLfloat param)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("light", GLESEnum::LightName, ParamType::TGLenum, light);
    paramBuffer.addValueParam("pnamePacked", ParamType::TLightParameter, pnamePacked);
    paramBuffer.addValueParam("param", ParamType::TGLfloat, param);

    return CallCapture(angle::EntryPoint::GLLightf, std::move(paramBuffer));
}

CallCapture CaptureLightfv(const State &glState,
                           bool isCallValid,
                           GLenum light,
                           LightParameter pnamePacked,
                           const GLfloat *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("light", GLESEnum::LightName, ParamType::TGLenum, light);
    paramBuffer.addValueParam("pnamePacked", ParamType::TLightParameter, pnamePacked);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, params, &paramsParam.value);
        CaptureLightfv_params(glState, isCallValid, light, pnamePacked, params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, static_cast<const GLfloat *>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLLightfv, std::move(paramBuffer));
}

CallCapture CaptureLightx(const State &glState,
                          bool isCallValid,
                          GLenum light,
                          LightParameter pnamePacked,
                          GLfixed param)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("light", GLESEnum::LightName, ParamType::TGLenum, light);
    paramBuffer.addValueParam("pnamePacked", ParamType::TLightParameter, pnamePacked);
    paramBuffer.addValueParam("param", ParamType::TGLfixed, param);

    return CallCapture(angle::EntryPoint::GLLightx, std::move(paramBuffer));
}

CallCapture CaptureLightxv(const State &glState,
                           bool isCallValid,
                           GLenum light,
                           LightParameter pnamePacked,
                           const GLfixed *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("light", GLESEnum::LightName, ParamType::TGLenum, light);
    paramBuffer.addValueParam("pnamePacked", ParamType::TLightParameter, pnamePacked);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLfixedConstPointer);
        InitParamValue(ParamType::TGLfixedConstPointer, params, &paramsParam.value);
        CaptureLightxv_params(glState, isCallValid, light, pnamePacked, params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLfixedConstPointer);
        InitParamValue(ParamType::TGLfixedConstPointer, static_cast<const GLfixed *>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLLightxv, std::move(paramBuffer));
}

CallCapture CaptureLineWidthx(const State &glState, bool isCallValid, GLfixed width)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("width", ParamType::TGLfixed, width);

    return CallCapture(angle::EntryPoint::GLLineWidthx, std::move(paramBuffer));
}

CallCapture CaptureLoadIdentity(const State &glState, bool isCallValid)
{
    ParamBuffer paramBuffer;

    return CallCapture(angle::EntryPoint::GLLoadIdentity, std::move(paramBuffer));
}

CallCapture CaptureLoadMatrixf(const State &glState, bool isCallValid, const GLfloat *m)
{
    ParamBuffer paramBuffer;

    if (isCallValid)
    {
        ParamCapture mParam("m", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, m, &mParam.value);
        CaptureLoadMatrixf_m(glState, isCallValid, m, &mParam);
        paramBuffer.addParam(std::move(mParam));
    }
    else
    {
        ParamCapture mParam("m", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, static_cast<const GLfloat *>(nullptr),
                       &mParam.value);
        paramBuffer.addParam(std::move(mParam));
    }

    return CallCapture(angle::EntryPoint::GLLoadMatrixf, std::move(paramBuffer));
}

CallCapture CaptureLoadMatrixx(const State &glState, bool isCallValid, const GLfixed *m)
{
    ParamBuffer paramBuffer;

    if (isCallValid)
    {
        ParamCapture mParam("m", ParamType::TGLfixedConstPointer);
        InitParamValue(ParamType::TGLfixedConstPointer, m, &mParam.value);
        CaptureLoadMatrixx_m(glState, isCallValid, m, &mParam);
        paramBuffer.addParam(std::move(mParam));
    }
    else
    {
        ParamCapture mParam("m", ParamType::TGLfixedConstPointer);
        InitParamValue(ParamType::TGLfixedConstPointer, static_cast<const GLfixed *>(nullptr),
                       &mParam.value);
        paramBuffer.addParam(std::move(mParam));
    }

    return CallCapture(angle::EntryPoint::GLLoadMatrixx, std::move(paramBuffer));
}

CallCapture CaptureLogicOp(const State &glState, bool isCallValid, LogicalOperation opcodePacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("opcodePacked", ParamType::TLogicalOperation, opcodePacked);

    return CallCapture(angle::EntryPoint::GLLogicOp, std::move(paramBuffer));
}

CallCapture CaptureMaterialf(const State &glState,
                             bool isCallValid,
                             GLenum face,
                             MaterialParameter pnamePacked,
                             GLfloat param)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("face", GLESEnum::TriangleFace, ParamType::TGLenum, face);
    paramBuffer.addValueParam("pnamePacked", ParamType::TMaterialParameter, pnamePacked);
    paramBuffer.addValueParam("param", ParamType::TGLfloat, param);

    return CallCapture(angle::EntryPoint::GLMaterialf, std::move(paramBuffer));
}

CallCapture CaptureMaterialfv(const State &glState,
                              bool isCallValid,
                              GLenum face,
                              MaterialParameter pnamePacked,
                              const GLfloat *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("face", GLESEnum::TriangleFace, ParamType::TGLenum, face);
    paramBuffer.addValueParam("pnamePacked", ParamType::TMaterialParameter, pnamePacked);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, params, &paramsParam.value);
        CaptureMaterialfv_params(glState, isCallValid, face, pnamePacked, params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, static_cast<const GLfloat *>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLMaterialfv, std::move(paramBuffer));
}

CallCapture CaptureMaterialx(const State &glState,
                             bool isCallValid,
                             GLenum face,
                             MaterialParameter pnamePacked,
                             GLfixed param)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("face", GLESEnum::TriangleFace, ParamType::TGLenum, face);
    paramBuffer.addValueParam("pnamePacked", ParamType::TMaterialParameter, pnamePacked);
    paramBuffer.addValueParam("param", ParamType::TGLfixed, param);

    return CallCapture(angle::EntryPoint::GLMaterialx, std::move(paramBuffer));
}

CallCapture CaptureMaterialxv(const State &glState,
                              bool isCallValid,
                              GLenum face,
                              MaterialParameter pnamePacked,
                              const GLfixed *param)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("face", GLESEnum::TriangleFace, ParamType::TGLenum, face);
    paramBuffer.addValueParam("pnamePacked", ParamType::TMaterialParameter, pnamePacked);

    if (isCallValid)
    {
        ParamCapture paramParam("param", ParamType::TGLfixedConstPointer);
        InitParamValue(ParamType::TGLfixedConstPointer, param, &paramParam.value);
        CaptureMaterialxv_param(glState, isCallValid, face, pnamePacked, param, &paramParam);
        paramBuffer.addParam(std::move(paramParam));
    }
    else
    {
        ParamCapture paramParam("param", ParamType::TGLfixedConstPointer);
        InitParamValue(ParamType::TGLfixedConstPointer, static_cast<const GLfixed *>(nullptr),
                       &paramParam.value);
        paramBuffer.addParam(std::move(paramParam));
    }

    return CallCapture(angle::EntryPoint::GLMaterialxv, std::move(paramBuffer));
}

CallCapture CaptureMatrixMode(const State &glState, bool isCallValid, MatrixType modePacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("modePacked", ParamType::TMatrixType, modePacked);

    return CallCapture(angle::EntryPoint::GLMatrixMode, std::move(paramBuffer));
}

CallCapture CaptureMultMatrixf(const State &glState, bool isCallValid, const GLfloat *m)
{
    ParamBuffer paramBuffer;

    if (isCallValid)
    {
        ParamCapture mParam("m", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, m, &mParam.value);
        CaptureMultMatrixf_m(glState, isCallValid, m, &mParam);
        paramBuffer.addParam(std::move(mParam));
    }
    else
    {
        ParamCapture mParam("m", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, static_cast<const GLfloat *>(nullptr),
                       &mParam.value);
        paramBuffer.addParam(std::move(mParam));
    }

    return CallCapture(angle::EntryPoint::GLMultMatrixf, std::move(paramBuffer));
}

CallCapture CaptureMultMatrixx(const State &glState, bool isCallValid, const GLfixed *m)
{
    ParamBuffer paramBuffer;

    if (isCallValid)
    {
        ParamCapture mParam("m", ParamType::TGLfixedConstPointer);
        InitParamValue(ParamType::TGLfixedConstPointer, m, &mParam.value);
        CaptureMultMatrixx_m(glState, isCallValid, m, &mParam);
        paramBuffer.addParam(std::move(mParam));
    }
    else
    {
        ParamCapture mParam("m", ParamType::TGLfixedConstPointer);
        InitParamValue(ParamType::TGLfixedConstPointer, static_cast<const GLfixed *>(nullptr),
                       &mParam.value);
        paramBuffer.addParam(std::move(mParam));
    }

    return CallCapture(angle::EntryPoint::GLMultMatrixx, std::move(paramBuffer));
}

CallCapture CaptureMultiTexCoord4f(const State &glState,
                                   bool isCallValid,
                                   GLenum target,
                                   GLfloat s,
                                   GLfloat t,
                                   GLfloat r,
                                   GLfloat q)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLESEnum::TextureUnit, ParamType::TGLenum, target);
    paramBuffer.addValueParam("s", ParamType::TGLfloat, s);
    paramBuffer.addValueParam("t", ParamType::TGLfloat, t);
    paramBuffer.addValueParam("r", ParamType::TGLfloat, r);
    paramBuffer.addValueParam("q", ParamType::TGLfloat, q);

    return CallCapture(angle::EntryPoint::GLMultiTexCoord4f, std::move(paramBuffer));
}

CallCapture CaptureMultiTexCoord4x(const State &glState,
                                   bool isCallValid,
                                   GLenum texture,
                                   GLfixed s,
                                   GLfixed t,
                                   GLfixed r,
                                   GLfixed q)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("texture", GLESEnum::TextureUnit, ParamType::TGLenum, texture);
    paramBuffer.addValueParam("s", ParamType::TGLfixed, s);
    paramBuffer.addValueParam("t", ParamType::TGLfixed, t);
    paramBuffer.addValueParam("r", ParamType::TGLfixed, r);
    paramBuffer.addValueParam("q", ParamType::TGLfixed, q);

    return CallCapture(angle::EntryPoint::GLMultiTexCoord4x, std::move(paramBuffer));
}

CallCapture CaptureNormal3f(const State &glState,
                            bool isCallValid,
                            GLfloat nx,
                            GLfloat ny,
                            GLfloat nz)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("nx", ParamType::TGLfloat, nx);
    paramBuffer.addValueParam("ny", ParamType::TGLfloat, ny);
    paramBuffer.addValueParam("nz", ParamType::TGLfloat, nz);

    return CallCapture(angle::EntryPoint::GLNormal3f, std::move(paramBuffer));
}

CallCapture CaptureNormal3x(const State &glState,
                            bool isCallValid,
                            GLfixed nx,
                            GLfixed ny,
                            GLfixed nz)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("nx", ParamType::TGLfixed, nx);
    paramBuffer.addValueParam("ny", ParamType::TGLfixed, ny);
    paramBuffer.addValueParam("nz", ParamType::TGLfixed, nz);

    return CallCapture(angle::EntryPoint::GLNormal3x, std::move(paramBuffer));
}

CallCapture CaptureNormalPointer(const State &glState,
                                 bool isCallValid,
                                 VertexAttribType typePacked,
                                 GLsizei stride,
                                 const void *pointer)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("typePacked", ParamType::TVertexAttribType, typePacked);
    paramBuffer.addValueParam("stride", ParamType::TGLsizei, stride);

    if (isCallValid)
    {
        ParamCapture pointerParam("pointer", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, pointer, &pointerParam.value);
        CaptureNormalPointer_pointer(glState, isCallValid, typePacked, stride, pointer,
                                     &pointerParam);
        paramBuffer.addParam(std::move(pointerParam));
    }
    else
    {
        ParamCapture pointerParam("pointer", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &pointerParam.value);
        paramBuffer.addParam(std::move(pointerParam));
    }

    return CallCapture(angle::EntryPoint::GLNormalPointer, std::move(paramBuffer));
}

CallCapture CaptureOrthof(const State &glState,
                          bool isCallValid,
                          GLfloat l,
                          GLfloat r,
                          GLfloat b,
                          GLfloat t,
                          GLfloat n,
                          GLfloat f)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("l", ParamType::TGLfloat, l);
    paramBuffer.addValueParam("r", ParamType::TGLfloat, r);
    paramBuffer.addValueParam("b", ParamType::TGLfloat, b);
    paramBuffer.addValueParam("t", ParamType::TGLfloat, t);
    paramBuffer.addValueParam("n", ParamType::TGLfloat, n);
    paramBuffer.addValueParam("f", ParamType::TGLfloat, f);

    return CallCapture(angle::EntryPoint::GLOrthof, std::move(paramBuffer));
}

CallCapture CaptureOrthox(const State &glState,
                          bool isCallValid,
                          GLfixed l,
                          GLfixed r,
                          GLfixed b,
                          GLfixed t,
                          GLfixed n,
                          GLfixed f)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("l", ParamType::TGLfixed, l);
    paramBuffer.addValueParam("r", ParamType::TGLfixed, r);
    paramBuffer.addValueParam("b", ParamType::TGLfixed, b);
    paramBuffer.addValueParam("t", ParamType::TGLfixed, t);
    paramBuffer.addValueParam("n", ParamType::TGLfixed, n);
    paramBuffer.addValueParam("f", ParamType::TGLfixed, f);

    return CallCapture(angle::EntryPoint::GLOrthox, std::move(paramBuffer));
}

CallCapture CapturePointParameterf(const State &glState,
                                   bool isCallValid,
                                   PointParameter pnamePacked,
                                   GLfloat param)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("pnamePacked", ParamType::TPointParameter, pnamePacked);
    paramBuffer.addValueParam("param", ParamType::TGLfloat, param);

    return CallCapture(angle::EntryPoint::GLPointParameterf, std::move(paramBuffer));
}

CallCapture CapturePointParameterfv(const State &glState,
                                    bool isCallValid,
                                    PointParameter pnamePacked,
                                    const GLfloat *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("pnamePacked", ParamType::TPointParameter, pnamePacked);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, params, &paramsParam.value);
        CapturePointParameterfv_params(glState, isCallValid, pnamePacked, params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, static_cast<const GLfloat *>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLPointParameterfv, std::move(paramBuffer));
}

CallCapture CapturePointParameterx(const State &glState,
                                   bool isCallValid,
                                   PointParameter pnamePacked,
                                   GLfixed param)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("pnamePacked", ParamType::TPointParameter, pnamePacked);
    paramBuffer.addValueParam("param", ParamType::TGLfixed, param);

    return CallCapture(angle::EntryPoint::GLPointParameterx, std::move(paramBuffer));
}

CallCapture CapturePointParameterxv(const State &glState,
                                    bool isCallValid,
                                    PointParameter pnamePacked,
                                    const GLfixed *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("pnamePacked", ParamType::TPointParameter, pnamePacked);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLfixedConstPointer);
        InitParamValue(ParamType::TGLfixedConstPointer, params, &paramsParam.value);
        CapturePointParameterxv_params(glState, isCallValid, pnamePacked, params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLfixedConstPointer);
        InitParamValue(ParamType::TGLfixedConstPointer, static_cast<const GLfixed *>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLPointParameterxv, std::move(paramBuffer));
}

CallCapture CapturePointSize(const State &glState, bool isCallValid, GLfloat size)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("size", ParamType::TGLfloat, size);

    return CallCapture(angle::EntryPoint::GLPointSize, std::move(paramBuffer));
}

CallCapture CapturePointSizex(const State &glState, bool isCallValid, GLfixed size)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("size", ParamType::TGLfixed, size);

    return CallCapture(angle::EntryPoint::GLPointSizex, std::move(paramBuffer));
}

CallCapture CapturePolygonOffsetx(const State &glState,
                                  bool isCallValid,
                                  GLfixed factor,
                                  GLfixed units)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("factor", ParamType::TGLfixed, factor);
    paramBuffer.addValueParam("units", ParamType::TGLfixed, units);

    return CallCapture(angle::EntryPoint::GLPolygonOffsetx, std::move(paramBuffer));
}

CallCapture CapturePopMatrix(const State &glState, bool isCallValid)
{
    ParamBuffer paramBuffer;

    return CallCapture(angle::EntryPoint::GLPopMatrix, std::move(paramBuffer));
}

CallCapture CapturePushMatrix(const State &glState, bool isCallValid)
{
    ParamBuffer paramBuffer;

    return CallCapture(angle::EntryPoint::GLPushMatrix, std::move(paramBuffer));
}

CallCapture CaptureRotatef(const State &glState,
                           bool isCallValid,
                           GLfloat angle,
                           GLfloat x,
                           GLfloat y,
                           GLfloat z)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("angle", ParamType::TGLfloat, angle);
    paramBuffer.addValueParam("x", ParamType::TGLfloat, x);
    paramBuffer.addValueParam("y", ParamType::TGLfloat, y);
    paramBuffer.addValueParam("z", ParamType::TGLfloat, z);

    return CallCapture(angle::EntryPoint::GLRotatef, std::move(paramBuffer));
}

CallCapture CaptureRotatex(const State &glState,
                           bool isCallValid,
                           GLfixed angle,
                           GLfixed x,
                           GLfixed y,
                           GLfixed z)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("angle", ParamType::TGLfixed, angle);
    paramBuffer.addValueParam("x", ParamType::TGLfixed, x);
    paramBuffer.addValueParam("y", ParamType::TGLfixed, y);
    paramBuffer.addValueParam("z", ParamType::TGLfixed, z);

    return CallCapture(angle::EntryPoint::GLRotatex, std::move(paramBuffer));
}

CallCapture CaptureSampleCoveragex(const State &glState,
                                   bool isCallValid,
                                   GLclampx value,
                                   GLboolean invert)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("value", ParamType::TGLclampx, value);
    paramBuffer.addValueParam("invert", ParamType::TGLboolean, invert);

    return CallCapture(angle::EntryPoint::GLSampleCoveragex, std::move(paramBuffer));
}

CallCapture CaptureScalef(const State &glState, bool isCallValid, GLfloat x, GLfloat y, GLfloat z)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("x", ParamType::TGLfloat, x);
    paramBuffer.addValueParam("y", ParamType::TGLfloat, y);
    paramBuffer.addValueParam("z", ParamType::TGLfloat, z);

    return CallCapture(angle::EntryPoint::GLScalef, std::move(paramBuffer));
}

CallCapture CaptureScalex(const State &glState, bool isCallValid, GLfixed x, GLfixed y, GLfixed z)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("x", ParamType::TGLfixed, x);
    paramBuffer.addValueParam("y", ParamType::TGLfixed, y);
    paramBuffer.addValueParam("z", ParamType::TGLfixed, z);

    return CallCapture(angle::EntryPoint::GLScalex, std::move(paramBuffer));
}

CallCapture CaptureShadeModel(const State &glState, bool isCallValid, ShadingModel modePacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("modePacked", ParamType::TShadingModel, modePacked);

    return CallCapture(angle::EntryPoint::GLShadeModel, std::move(paramBuffer));
}

CallCapture CaptureTexCoordPointer(const State &glState,
                                   bool isCallValid,
                                   GLint size,
                                   VertexAttribType typePacked,
                                   GLsizei stride,
                                   const void *pointer)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("size", ParamType::TGLint, size);
    paramBuffer.addValueParam("typePacked", ParamType::TVertexAttribType, typePacked);
    paramBuffer.addValueParam("stride", ParamType::TGLsizei, stride);

    if (isCallValid)
    {
        ParamCapture pointerParam("pointer", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, pointer, &pointerParam.value);
        CaptureTexCoordPointer_pointer(glState, isCallValid, size, typePacked, stride, pointer,
                                       &pointerParam);
        paramBuffer.addParam(std::move(pointerParam));
    }
    else
    {
        ParamCapture pointerParam("pointer", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &pointerParam.value);
        paramBuffer.addParam(std::move(pointerParam));
    }

    return CallCapture(angle::EntryPoint::GLTexCoordPointer, std::move(paramBuffer));
}

CallCapture CaptureTexEnvf(const State &glState,
                           bool isCallValid,
                           TextureEnvTarget targetPacked,
                           TextureEnvParameter pnamePacked,
                           GLfloat param)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureEnvTarget, targetPacked);
    paramBuffer.addValueParam("pnamePacked", ParamType::TTextureEnvParameter, pnamePacked);
    paramBuffer.addValueParam("param", ParamType::TGLfloat, param);

    return CallCapture(angle::EntryPoint::GLTexEnvf, std::move(paramBuffer));
}

CallCapture CaptureTexEnvfv(const State &glState,
                            bool isCallValid,
                            TextureEnvTarget targetPacked,
                            TextureEnvParameter pnamePacked,
                            const GLfloat *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureEnvTarget, targetPacked);
    paramBuffer.addValueParam("pnamePacked", ParamType::TTextureEnvParameter, pnamePacked);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, params, &paramsParam.value);
        CaptureTexEnvfv_params(glState, isCallValid, targetPacked, pnamePacked, params,
                               &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, static_cast<const GLfloat *>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLTexEnvfv, std::move(paramBuffer));
}

CallCapture CaptureTexEnvi(const State &glState,
                           bool isCallValid,
                           TextureEnvTarget targetPacked,
                           TextureEnvParameter pnamePacked,
                           GLint param)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureEnvTarget, targetPacked);
    paramBuffer.addValueParam("pnamePacked", ParamType::TTextureEnvParameter, pnamePacked);
    paramBuffer.addValueParam("param", ParamType::TGLint, param);

    return CallCapture(angle::EntryPoint::GLTexEnvi, std::move(paramBuffer));
}

CallCapture CaptureTexEnviv(const State &glState,
                            bool isCallValid,
                            TextureEnvTarget targetPacked,
                            TextureEnvParameter pnamePacked,
                            const GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureEnvTarget, targetPacked);
    paramBuffer.addValueParam("pnamePacked", ParamType::TTextureEnvParameter, pnamePacked);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, params, &paramsParam.value);
        CaptureTexEnviv_params(glState, isCallValid, targetPacked, pnamePacked, params,
                               &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, static_cast<const GLint *>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLTexEnviv, std::move(paramBuffer));
}

CallCapture CaptureTexEnvx(const State &glState,
                           bool isCallValid,
                           TextureEnvTarget targetPacked,
                           TextureEnvParameter pnamePacked,
                           GLfixed param)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureEnvTarget, targetPacked);
    paramBuffer.addValueParam("pnamePacked", ParamType::TTextureEnvParameter, pnamePacked);
    paramBuffer.addValueParam("param", ParamType::TGLfixed, param);

    return CallCapture(angle::EntryPoint::GLTexEnvx, std::move(paramBuffer));
}

CallCapture CaptureTexEnvxv(const State &glState,
                            bool isCallValid,
                            TextureEnvTarget targetPacked,
                            TextureEnvParameter pnamePacked,
                            const GLfixed *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureEnvTarget, targetPacked);
    paramBuffer.addValueParam("pnamePacked", ParamType::TTextureEnvParameter, pnamePacked);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLfixedConstPointer);
        InitParamValue(ParamType::TGLfixedConstPointer, params, &paramsParam.value);
        CaptureTexEnvxv_params(glState, isCallValid, targetPacked, pnamePacked, params,
                               &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLfixedConstPointer);
        InitParamValue(ParamType::TGLfixedConstPointer, static_cast<const GLfixed *>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLTexEnvxv, std::move(paramBuffer));
}

CallCapture CaptureTexParameterx(const State &glState,
                                 bool isCallValid,
                                 TextureType targetPacked,
                                 GLenum pname,
                                 GLfixed param)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addEnumParam("pname", GLESEnum::GetTextureParameter, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("param", ParamType::TGLfixed, param);

    return CallCapture(angle::EntryPoint::GLTexParameterx, std::move(paramBuffer));
}

CallCapture CaptureTexParameterxv(const State &glState,
                                  bool isCallValid,
                                  TextureType targetPacked,
                                  GLenum pname,
                                  const GLfixed *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addEnumParam("pname", GLESEnum::GetTextureParameter, ParamType::TGLenum, pname);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLfixedConstPointer);
        InitParamValue(ParamType::TGLfixedConstPointer, params, &paramsParam.value);
        CaptureTexParameterxv_params(glState, isCallValid, targetPacked, pname, params,
                                     &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLfixedConstPointer);
        InitParamValue(ParamType::TGLfixedConstPointer, static_cast<const GLfixed *>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLTexParameterxv, std::move(paramBuffer));
}

CallCapture CaptureTranslatef(const State &glState,
                              bool isCallValid,
                              GLfloat x,
                              GLfloat y,
                              GLfloat z)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("x", ParamType::TGLfloat, x);
    paramBuffer.addValueParam("y", ParamType::TGLfloat, y);
    paramBuffer.addValueParam("z", ParamType::TGLfloat, z);

    return CallCapture(angle::EntryPoint::GLTranslatef, std::move(paramBuffer));
}

CallCapture CaptureTranslatex(const State &glState,
                              bool isCallValid,
                              GLfixed x,
                              GLfixed y,
                              GLfixed z)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("x", ParamType::TGLfixed, x);
    paramBuffer.addValueParam("y", ParamType::TGLfixed, y);
    paramBuffer.addValueParam("z", ParamType::TGLfixed, z);

    return CallCapture(angle::EntryPoint::GLTranslatex, std::move(paramBuffer));
}

CallCapture CaptureVertexPointer(const State &glState,
                                 bool isCallValid,
                                 GLint size,
                                 VertexAttribType typePacked,
                                 GLsizei stride,
                                 const void *pointer)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("size", ParamType::TGLint, size);
    paramBuffer.addValueParam("typePacked", ParamType::TVertexAttribType, typePacked);
    paramBuffer.addValueParam("stride", ParamType::TGLsizei, stride);

    if (isCallValid)
    {
        ParamCapture pointerParam("pointer", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, pointer, &pointerParam.value);
        CaptureVertexPointer_pointer(glState, isCallValid, size, typePacked, stride, pointer,
                                     &pointerParam);
        paramBuffer.addParam(std::move(pointerParam));
    }
    else
    {
        ParamCapture pointerParam("pointer", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &pointerParam.value);
        paramBuffer.addParam(std::move(pointerParam));
    }

    return CallCapture(angle::EntryPoint::GLVertexPointer, std::move(paramBuffer));
}

}  // namespace gl
