#!/usr/bin/env bats
# Test to check if the available ciphers change when a new policy is set.

. ./openssh/shared

get_ssh_client_ciphers() {
    ssh -T -G host | grep_config_values ciphers
}
get_ssh_server_ciphers() {
    sshd -T | grep_config_values ciphers
}

update-crypto-policies --set LEGACY > /dev/null
legacy_client_ciphers="$(get_ssh_client_ciphers)"
legacy_server_ciphers="$(get_ssh_server_ciphers)"
update-crypto-policies --set DEFAULT > /dev/null
default_client_ciphers="$(get_ssh_client_ciphers)"
default_server_ciphers="$(get_ssh_server_ciphers)"
update-crypto-policies --set FUTURE > /dev/null
future_client_ciphers="$(get_ssh_client_ciphers)"
future_server_ciphers="$(get_ssh_server_ciphers)"

@test "LEGACY ciphers differ from DEFAULT (client)" {
    run diff <(printf '%s\n' "$legacy_client_ciphers") <(printf '%s\n' "$default_client_ciphers")
    [ "$status" -eq 1 ]
}

@test "LEGACY ciphers differ from DEFAULT (server)" {
    run diff <(printf '%s\n' "$legacy_server_ciphers") <(printf '%s\n' "$default_server_ciphers")
    [ "$status" -eq 1 ]
}

@test "LEGACY ciphers differ from FUTURE (client)" {
    run diff <(printf '%s\n' "$legacy_client_ciphers") <(printf '%s\n' "$future_client_ciphers")
    [ "$status" -eq 1 ]
}

@test "LEGACY ciphers differ from FUTURE (server)" {
    run diff <(printf '%s\n' "$legacy_server_ciphers") <(printf '%s\n' "$future_server_ciphers")
    [ "$status" -eq 1 ]
}

@test "DEFAULT ciphers differ from FUTURE (client)" {
    run diff <(printf '%s\n' "$default_client_ciphers") <(printf '%s\n' "$future_client_ciphers")
    [ "$status" -eq 1 ]
}

@test "DEFAULT ciphers differ from FUTURE (server)" {
    run diff <(printf '%s\n' "$default_server_ciphers") <(printf '%s\n' "$future_server_ciphers")
    [ "$status" -eq 1 ]
}

@test "Idempotency: setting same policy twice does not change ciphers" {
    update-crypto-policies --set FUTURE > /dev/null
    first_ciphers="$(get_ssh_client_ciphers)"
    update-crypto-policies --set FUTURE > /dev/null
    other_ciphers="$(get_ssh_client_ciphers)"
    run diff <(printf '%s\n' "$first_ciphers") <(printf '%s\n' "$other_ciphers")
    [ "$status" -eq 0 ]
}
