"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.writeFont = writeFont;
const io_bin_encoding_1 = require("@ot-builder/io-bin-encoding");
const io_bin_ext_private_1 = require("@ot-builder/io-bin-ext-private");
const io_bin_glyph_store_1 = require("@ot-builder/io-bin-glyph-store");
const io_bin_layout_1 = require("@ot-builder/io-bin-layout");
const io_bin_metadata_1 = require("@ot-builder/io-bin-metadata");
const io_bin_name_1 = require("@ot-builder/io-bin-name");
const io_bin_sfnt_1 = require("@ot-builder/io-bin-sfnt");
const io_bin_vtt_private_1 = require("@ot-builder/io-bin-vtt-private");
const Ot = require("@ot-builder/ot");
const ot_sfnt_1 = require("@ot-builder/ot-sfnt");
const config_1 = require("./config");
// Lenses here are somehow unnecessary, but it will prevent random errors in the write code
function MD(font, naming) {
    return { ...font, postGlyphNaming: naming };
}
function Names(font) {
    return font;
}
function CffCoGlyphs(font) {
    return font;
}
function TtfCoGlyphs(font) {
    return font;
}
function Encoding(font) {
    return font;
}
function OTL(font) {
    return font;
}
function ExtPrivate(font) {
    return font;
}
function VttPrivate(font) {
    return font;
}
class WritePostNaming {
    constructor(gOrd) {
        this.gOrd = gOrd;
    }
    getName(gid) {
        return this.gOrd.at(gid).name;
    }
}
function writeFont(font, partialConfig = {}) {
    const sfnt = new ot_sfnt_1.Sfnt(Ot.Font.isCff(font) ? 0x4f54544f : 0x00010000);
    const sink = new io_bin_sfnt_1.SfntIoTableSink(sfnt);
    const fullCfg = (0, config_1.createConfig)(partialConfig);
    const gOrd = font.glyphs.decideOrder();
    // Alias fonts
    const md = MD(font, new WritePostNaming(gOrd));
    (0, io_bin_layout_1.writeOtl)(sink, OTL(font), fullCfg, gOrd, md);
    (0, io_bin_encoding_1.writeEncoding)(sink, fullCfg, Encoding(font), gOrd, md);
    const extraInfoSink = new io_bin_vtt_private_1.VttExtraInfoSinkImpl();
    if (Ot.Font.isCff(font)) {
        (0, io_bin_glyph_store_1.writeGlyphStore)(sink, fullCfg, md, CffCoGlyphs(font), gOrd, extraInfoSink, io_bin_glyph_store_1.WriteCffGlyphs);
    }
    else {
        (0, io_bin_glyph_store_1.writeGlyphStore)(sink, fullCfg, md, TtfCoGlyphs(font), gOrd, extraInfoSink, io_bin_glyph_store_1.WriteTtfGlyphs);
    }
    (0, io_bin_name_1.writeNames)(sink, Names(font));
    (0, io_bin_metadata_1.writeOtMetadata)(sink, fullCfg, md);
    (0, io_bin_ext_private_1.writeExtPrivate)(sink, fullCfg, ExtPrivate(font), gOrd, md);
    (0, io_bin_vtt_private_1.writeVttPrivate)(sink, fullCfg, VttPrivate(font), gOrd, md, extraInfoSink);
    if (fullCfg.generateDummyDigitalSignature) {
        sink.add("DSIG", Buffer.from([0, 0, 0, 1, 0, 0, 0, 0]));
    }
    return sfnt;
}
//# sourceMappingURL=write.js.map