"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.transformShape = exports.CompositeTransform = exports.LinearTransform = void 0;
const jacobian_1 = require("../point/jacobian");
const point_1 = require("../point/point");
const arcs_1 = require("./arcs");
class LinearTransform {
    constructor(xx, xy, yx, yy, x, y) {
        this.xx = xx;
        this.xy = xy;
        this.yx = yx;
        this.yy = yy;
        this.tx = x;
        this.ty = y;
        this.j = new jacobian_1.Jacobian2(this.xx, this.xy, this.yx, this.yy);
    }
    eval(t) {
        return new point_1.Point2(t.x * this.xx + t.y * this.xy + this.tx, t.x * this.yx + t.y * this.yy + this.ty);
    }
    derivative(_t) {
        return this.j;
    }
    inverse() {
        const denom = this.xx * this.yy - this.yx * this.xy;
        return new LinearTransform(this.yy / denom, -this.xy / denom, -this.yx / denom, this.xx / denom, -(this.tx * this.yy - this.ty * this.xy) / denom, -(-this.tx * this.yx + this.ty * this.xx) / denom);
    }
}
exports.LinearTransform = LinearTransform;
LinearTransform.neutral = new LinearTransform(1, 0, 0, 1, 0, 0);
class CompositeTransform {
    constructor(b, a) {
        this.b = b;
        this.a = a;
    }
    eval(z) {
        return this.b.eval(this.a.eval(z));
    }
    derivative(z) {
        const z1 = this.a.eval(z);
        const j1 = this.a.derivative(z);
        const j2 = this.b.derivative(z1);
        return jacobian_1.Jacobian2.multiply(j2, j1);
    }
    static from(a, b) {
        if (a === LinearTransform.neutral)
            return b;
        if (b === LinearTransform.neutral)
            return a;
        return new CompositeTransform(a, b);
    }
}
exports.CompositeTransform = CompositeTransform;
function transformShape(sh, tfm) {
    let out = [];
    for (let j = 0; j < sh.length; j++) {
        const c = sh[j];
        const contour = [];
        for (let k = 0; k < c.length; k++) {
            contour[k] = new arcs_1.Transformed(tfm, c[k]);
        }
        out[j] = contour;
    }
    return out;
}
exports.transformShape = transformShape;
