/*************************************************************************
**
**    This file is part of the 'forwords' educational programm.
**    Copyright (C) 2024  Alexander Fomin
**
**    This program is free software: you can redistribute it and/or modify
**    it under the terms of the GNU General Public License as published by
**    the Free Software Foundation, either version 3 of the License, or
**    (at your option) any later version.
**
**    This program is distributed in the hope that it will be useful,
**    but WITHOUT ANY WARRANTY; without even the implied warranty of
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**    GNU General Public License for more details.
**
**    You should have received a copy of the GNU General Public License
**    along with this program.  If not, see <https://www.gnu.org/licenses/>.
**
**    Contact: fomin_alex@yahoo.com
**
**************************************************************************/

#ifndef COMMON_H
#define COMMON_H

#endif // COMMON_H
#include <QMessageBox>
#include <QInputDialog>
#include <QDir>
#include "tts.h"

inline static void fShowMsg(QString s,QMessageBox::Icon icon = QMessageBox::Information)
{
    QMessageBox msgbox;
    msgbox.setText(s);
    msgbox.setIcon(icon);
    msgbox.exec();
}
inline QString fShowStrInputDlg(QWidget *parent,QString lable)
{
    QInputDialog inDlg;
    return inDlg.getText(parent,"Text input dialog",lable);
}

inline QStringList fDirList(QDir dir)
{
    QStringList sl = dir.entryList(QDir::Dirs);
    sl.removeOne(".");
    sl.removeOne("..");
    return sl;
}

inline QStringList fFileList(QString path,QString extention)
{
    QStringList sl, sl1;
    sl.append("*."+extention);
    sl1 = QDir(path).entryList(sl,QDir::Files);
    for (int i = 0; i < sl1.count(); ++i)
    {
        sl1[i].remove("."+extention);
    }
    return sl1;
}

//++++++ wxString conversion func ++++++++++++++
inline QString fPercent(int* vRange, int* vValue)
{
    int pr = 100 * *vValue / *vRange;
    return QString().setNum(pr) + "%";
}

//+++++++ math ++++++++++++++++++++++
inline int fRandom(int *vRange)
{
    int k = RAND_MAX / *vRange;
    return rand()/k;
}
