/* Frobby: Software for monomial ideal computations.
   Copyright (C) 2010 University of Aarhus
   Contact Bjarke Hammersholt Roune for license information (www.broune.com)

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see http://www.gnu.org/licenses/.
*/
#include "stdinc.h"
#include "BigIntVector.h"

bool operator==(const BigIntVector& a, const BigIntVector& b) {
  if (a.getSize() != b.getSize())
	return false;
  for (size_t i = 0; i < a.getSize(); ++i)
	if (a[i] != b[i])
	  return false;
  return true;
}

ostream& operator<<(ostream& out, const BigIntVector& v) {
  if (v.getSize() > 0)
	out << v[0];
  for (size_t i = 1; i < v.getSize(); ++i)
	out << ' ' << v[i];
  return out;
}
