---
myst:
  html_meta:
    keywords: LaTeX, composition, texte, page, numérotation des pages, nombre de pages
---

# Comment modifier le style de la numérotation des pages ?

## Avec la commande `\pagenumbering`

Le style de la numérotation est modifiable avec la commande `\pagenumbering{⟨style⟩}`. 
Le `⟨style⟩` peut prendre les valeurs suivantes :
- `alph` : a, b, c... Au-delà de la page "z", LaTeX génère une erreur : "LaTeX Error: Counter too large" ;
- `Alph` : A, B, C... Au-delà de la page "Z", LaTeX génère une erreur : "LaTeX Error: Counter too large" ;
- `arabic` : 1, 2, 3... C'est le style par défaut ;
- `gobble` : absence de numérotation. Cette possibilité est décrite à la question "[](supprimer_les_numeros_de_pages)".
- `roman` : i, ii, iii...
- `Roman` : I, II, III...

Il faut noter que, lorsque cette commande est appelée, la numérotation est réinitialisée à 1.

Voici un exemple *non recommandable* :

```
\documentclass[french]{book}
  \usepackage[T1]{fontenc}    % Encodage T1 
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \usepackage{lipsum}         % Du faux texte

\begin{document}
\pagenumbering{alph}
\tableofcontents
\chapter{Un classique incontournable}
\pagenumbering{arabic}
\lipsum[1-6] % Le faux texte
\chapter{Un classique incontournable - Suite}
\pagenumbering{Roman}
\lipsum[7-12] % Le faux texte
\end{document}
```


## Avec les commandes `\frontmatter`, `\mainmatter` et `\backmatter`

Les commandes `\frontmatter`, `\mainmatter` et `\backmatter` permettent de scinder 
un document de classe `book` en trois parties parties, chacune étant numérotée spécifiquement :
- `\frontmatter` numérote les pages en style `roman` ;
- `\mainmatter` et `\backmatter` numérotent les pages en style `arabic`.

Ces commandes modifient également le format des titres de chapitre. 
Ce point est décrit à la question "[](/3_composition/texte/titres/titres_non_numerotes)".

```
\documentclass[french]{book}
  \usepackage[T1]{fontenc}    % Encodage T1 
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \usepackage{lipsum}         % Du faux texte

\begin{document}
\frontmatter
\tableofcontents
\mainmatter
\chapter{Un classique incontournable}
\lipsum[1-6] % Le faux texte
\backmatter
\chapter{Un classique incontournable - Suite}
\lipsum[7-12] % Le faux texte
\end{document}
```


## Avec une redéfinition de `\thepage`

Pour obtenir des résultats plus complexe, il faut modifier la commande `\thepage`.
L'exemple suivant permet d'afficher un compteur comprenant, 
en plus du numéro de la page, le numéro du chapitre courant. 
La lisibilité n'est évidemment pas un modèle du genre.

```
\documentclass[french]{book}
  \usepackage[T1]{fontenc}    % Encodage T1 
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \usepackage{lipsum}         % Du faux texte

  \renewcommand{\thepage}{\thechapter-\roman{page}}

\begin{document}
\tableofcontents
\chapter{Un classique incontournable}
\lipsum[1-6] % Le faux texte
\chapter{Un classique incontournable - Suite}
\lipsum[7-12] % Le faux texte
\end{document}
```

:::{sources}
- [\pagenumbering](https://latexref.xyz/fr/_005cpagenumbering.html#g_t_005cpagenumbering)
:::