// Copyright(C) 1999-2020 National Technology & Engineering Solutions
// of Sandia, LLC (NTESS).  Under the terms of Contract DE-NA0003525 with
// NTESS, the U.S. Government retains certain rights in this software.
//
// See packages/seacas/LICENSE for details

#include <fmt/format.h>
#include <string>

std::string copyright(const std::string &year_range)
{
  return fmt::format("\n"
                     "Copyright(C) {} National Technology & Engineering Solutions of\n"
                     "Sandia, LLC (NTESS).  Under the terms of Contract DE-NA0003525 with\n"
                     "NTESS, the U.S. Government retains certain rights in this software.\n"
                     "\n"
                     "Redistribution and use in source and binary forms, with or without\n"
                     "modification, are permitted provided that the following conditions are\n"
                     "met:\n"
                     "\n"
                     "* Redistributions of source code must retain the above copyright\n"
                     "   notice, this list of conditions and the following disclaimer.\n"
                     "\n"
                     "* Redistributions in binary form must reproduce the above\n"
                     "  copyright notice, this list of conditions and the following\n"
                     "  disclaimer in the documentation and/or other materials provided\n"
                     "  with the distribution.\n"
                     "\n"
                     "* Neither the name of NTESS nor the names of its\n"
                     "  contributors may be used to endorse or promote products derived\n"
                     "  from this software without specific prior written permission.\n"
                     "\n"
                     "THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS\n"
                     "\" AS IS \" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT\n"
                     "LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR\n"
                     "A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT\n"
                     "OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,\n"
                     "SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT\n"
                     "LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,\n"
                     "DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY\n"
                     "THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT\n"
                     "(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE\n"
                     "OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.\n"
                     "\n",
                     year_range);
}
