/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.discovery.util;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class RateLimiter {
    private final long rateToMsConversion;
    private final AtomicInteger consumedTokens = new AtomicInteger();
    private final AtomicLong lastRefillTime = new AtomicLong(0L);

    @Deprecated
    public RateLimiter() {
        this(TimeUnit.SECONDS);
    }

    public RateLimiter(TimeUnit averageRateUnit) {
        switch (averageRateUnit) {
            case SECONDS: {
                this.rateToMsConversion = 1000L;
                break;
            }
            case MINUTES: {
                this.rateToMsConversion = 60000L;
                break;
            }
            default: {
                throw new IllegalArgumentException("TimeUnit of " + (Object)((Object)averageRateUnit) + " is not supported");
            }
        }
    }

    public boolean acquire(int burstSize, long averageRate) {
        return this.acquire(burstSize, averageRate, System.currentTimeMillis());
    }

    public boolean acquire(int burstSize, long averageRate, long currentTimeMillis) {
        if (burstSize <= 0 || averageRate <= 0L) {
            return true;
        }
        this.refillToken(burstSize, averageRate, currentTimeMillis);
        return this.consumeToken(burstSize);
    }

    private void refillToken(int burstSize, long averageRate, long currentTimeMillis) {
        long refillTime = this.lastRefillTime.get();
        long timeDelta = currentTimeMillis - refillTime;
        long newTokens = timeDelta * averageRate / this.rateToMsConversion;
        if (newTokens > 0L) {
            long newRefillTime;
            long l = newRefillTime = refillTime == 0L ? currentTimeMillis : refillTime + newTokens * this.rateToMsConversion / averageRate;
            if (this.lastRefillTime.compareAndSet(refillTime, newRefillTime)) {
                int adjustedLevel;
                int newLevel;
                int currentLevel;
                while (!this.consumedTokens.compareAndSet(currentLevel = this.consumedTokens.get(), newLevel = (int)Math.max(0L, (long)(adjustedLevel = Math.min(currentLevel, burstSize)) - newTokens))) {
                }
                return;
            }
        }
    }

    private boolean consumeToken(int burstSize) {
        int currentLevel;
        do {
            if ((currentLevel = this.consumedTokens.get()) < burstSize) continue;
            return false;
        } while (!this.consumedTokens.compareAndSet(currentLevel, currentLevel + 1));
        return true;
    }

    public void reset() {
        this.consumedTokens.set(0);
        this.lastRefillTime.set(0L);
    }
}

